/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.ReflectionCache;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;

public class InternalCacheFactory<K, V>
extends AbstractNamedCacheComponentFactory {
    private ClassLoader defaultClassLoader;

    public Cache<K, V> createCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName, ReflectionCache reflectionCache) throws ConfigurationException {
        try {
            return this.createAndWire(configuration, globalComponentRegistry, cacheName, reflectionCache);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AdvancedCache<K, V> createAndWire(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName, ReflectionCache reflectionCache) throws Exception {
        CacheImpl cache = new CacheImpl(cacheName);
        this.bootstrap(cacheName, cache, configuration, globalComponentRegistry, reflectionCache);
        return cache;
    }

    private void bootstrap(String cacheName, AdvancedCache cache, Configuration configuration, GlobalComponentRegistry globalComponentRegistry, ReflectionCache reflectionCache) {
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, reflectionCache);
        this.componentRegistry.registerDefaultClassLoader(this.defaultClassLoader);
        this.componentRegistry.notifyCacheStarting(configuration);
        this.componentRegistry.registerComponent((Object)cache, Cache.class);
        this.componentRegistry.registerComponent((Object)new CacheJmxRegistration(), CacheJmxRegistration.class);
        this.componentRegistry.registerComponent((Object)new RecoveryAdminOperations(), RecoveryAdminOperations.class);
    }

    public void setDefaultClassLoader(ClassLoader loader) {
        this.defaultClassLoader = loader;
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }
}

