/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.locks.containers.LockContainer;

public abstract class AbstractPerEntryLockContainer
implements LockContainer {
    protected final ConcurrentMap<Object, Lock> locks;

    protected AbstractPerEntryLockContainer(int concurrencyLevel) {
        this.locks = new ConcurrentHashMap<Object, Lock>(16, 0.75f, concurrencyLevel);
    }

    protected abstract Lock newLock();

    @Override
    public final Lock getLock(Object key) {
        Lock existingLock;
        Lock lock = (Lock)this.locks.get(key);
        if (lock == null) {
            lock = this.newLock();
        }
        if ((existingLock = this.locks.putIfAbsent(key, lock)) != null) {
            lock = existingLock;
        }
        return lock;
    }

    @Override
    public int getNumLocksHeld() {
        return this.locks.size();
    }

    @Override
    public int size() {
        return this.locks.size();
    }

    @Override
    public Lock acquireLock(Object key, long timeout, TimeUnit unit) throws InterruptedException {
        block4: {
            Lock lock;
            while (true) {
                lock = this.getLock(key);
                boolean locked = false;
                try {
                    locked = lock.tryLock(timeout, unit);
                }
                catch (InterruptedException ie) {
                    Util.safeRelease(lock);
                    throw ie;
                }
                catch (Throwable th) {
                    Util.safeRelease(lock);
                    locked = false;
                }
                if (!locked) break block4;
                Lock existingLock = this.locks.putIfAbsent(key, lock);
                if (existingLock == null || existingLock == lock) break;
                Util.safeRelease(lock);
            }
            return lock;
        }
        return null;
    }

    @Override
    public void releaseLock(Object key) {
        Lock l = (Lock)this.locks.remove(key);
        if (l != null) {
            l.unlock();
        }
    }

    @Override
    public int getLockId(Object key) {
        return System.identityHashCode(this.getLock(key));
    }
}

