/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.concurrent.Semaphore;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.NodeManager;
import org.hornetq.utils.UUIDGenerator;

public class InVMNodeManager
extends NodeManager {
    private Semaphore liveLock;
    private Semaphore backupLock;
    public State state = State.NOT_STARTED;

    public InVMNodeManager() {
        this.liveLock = new Semaphore(1);
        this.backupLock = new Semaphore(1);
        this.uuid = UUIDGenerator.getInstance().generateUUID();
        this.nodeID = new SimpleString(this.uuid.toString());
    }

    @Override
    public void awaitLiveNode() throws Exception {
        while (true) {
            if (this.state == State.NOT_STARTED) {
                Thread.sleep(2000L);
                continue;
            }
            this.liveLock.acquire();
            if (this.state == State.PAUSED) {
                this.liveLock.release();
                Thread.sleep(2000L);
                continue;
            }
            if (this.state == State.FAILING_BACK) {
                this.liveLock.release();
                Thread.sleep(2000L);
                continue;
            }
            if (this.state == State.LIVE) break;
        }
    }

    @Override
    public void startBackup() throws Exception {
        this.backupLock.acquire();
    }

    @Override
    public void startLiveNode() throws Exception {
        this.state = State.FAILING_BACK;
        this.liveLock.acquire();
        this.state = State.LIVE;
    }

    @Override
    public void pauseLiveServer() throws Exception {
        this.state = State.PAUSED;
        this.liveLock.release();
    }

    @Override
    public void crashLiveServer() throws Exception {
        this.state = State.LIVE;
        this.liveLock.release();
    }

    @Override
    public void stopBackup() throws Exception {
        this.backupLock.release();
    }

    @Override
    public void releaseBackup() {
        this.releaseBackupNode();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.state == State.FAILING_BACK;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        return this.liveLock.availablePermits() == 0;
    }

    @Override
    public void interrupt() {
    }

    private void releaseBackupNode() {
        if (this.backupLock != null) {
            this.backupLock.release();
        }
    }

    public static enum State {
        LIVE,
        PAUSED,
        FAILING_BACK,
        NOT_STARTED;

    }
}

