/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.MapReduceCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.RemoveRecoveryInfoCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    Transport transport;
    EmbeddedCacheManager cacheManager;
    GlobalComponentRegistry registry;
    Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(Transport transport, EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.transport = transport;
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters, byte type) {
        ReplicableCommand command;
        block28: {
            block27: {
                if (type != 0) break block27;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block28;
                    }
                    case 3: {
                        command = new LockControlCommand();
                        break block28;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block28;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block28;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block28;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block28;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block28;
                    }
                    case 12: {
                        command = new PrepareCommand();
                        break block28;
                    }
                    case 14: {
                        command = new CommitCommand();
                        break block28;
                    }
                    case 13: {
                        command = new RollbackCommand();
                        break block28;
                    }
                    case 2: {
                        command = new MultipleRpcCommand();
                        break block28;
                    }
                    case 1: {
                        command = new SingleRpcCommand();
                        break block28;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block28;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block28;
                    }
                    case 15: {
                        command = new StateTransferControlCommand();
                        ((StateTransferControlCommand)command).init(this.transport);
                        break block28;
                    }
                    case 16: {
                        command = new ClusteredGetCommand();
                        break block28;
                    }
                    case 17: {
                        command = new RehashControlCommand(this.transport);
                        break block28;
                    }
                    case 18: {
                        command = new RemoveCacheCommand(this.cacheManager, this.registry);
                        break block28;
                    }
                    case 22: {
                        command = new RemoveRecoveryInfoCommand();
                        break block28;
                    }
                    case 21: {
                        command = new GetInDoubtTransactionsCommand();
                        break block28;
                    }
                    case 20: {
                        command = new MapReduceCommand();
                        break block28;
                    }
                    case 19: {
                        command = new DistributedExecuteCommand();
                        break block28;
                    }
                    case 23: {
                        command = new GetInDoubtTxInfoCommand();
                        break block28;
                    }
                    case 24: {
                        command = new CompleteTransactionCommand();
                        break block28;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }
}

