/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum JacORBElement {
    UNKNOWN(null),
    ORB_CONFIG("orb"),
    ORB_CONNECTION_CONFIG("connection"),
    ORB_NAMING_CONFIG("naming"),
    POA_CONFIG("poa"),
    POA_REQUEST_PROC_CONFIG("request-processors"),
    INTEROP_CONFIG("interop"),
    SECURITY_CONFIG("security"),
    INITIALIZERS_CONFIG("initializers"),
    PROPERTY_CONFIG("property");

    private final String name;
    private static final Map<String, JacORBElement> MAP;

    private JacORBElement(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static JacORBElement forName(String localName) {
        JacORBElement element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public static EnumSet<JacORBElement> getRootElements() {
        return EnumSet.of(ORB_CONFIG, new JacORBElement[]{POA_CONFIG, INTEROP_CONFIG, SECURITY_CONFIG, PROPERTY_CONFIG, INITIALIZERS_CONFIG});
    }

    static {
        HashMap<String, JacORBElement> map = new HashMap<String, JacORBElement>();
        for (JacORBElement element : JacORBElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

