/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import javax.ejb.SessionBean;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.NotBusinessMethodInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanSetSessionContextMethodInvocationInterceptor;
import org.jboss.as.ejb3.component.session.SessionInvocationContextInterceptor;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.ejb3.tx.CMTTxInterceptorFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public abstract class SessionBeanComponentDescription
extends EJBComponentDescription {
    private static final Logger logger = Logger.getLogger(SessionBeanComponentDescription.class);
    private boolean noInterfaceViewPresent;
    private ConcurrencyManagementType concurrencyManagementType;
    private Map<String, LockType> beanLevelLockType = new HashMap<String, LockType>();
    private Map<String, AccessTimeout> beanLevelAccessTimeout = new HashMap<String, AccessTimeout>();
    private Map<MethodIdentifier, LockType> methodLockTypes = new ConcurrentHashMap<MethodIdentifier, LockType>();
    private Map<MethodIdentifier, AccessTimeout> methodAccessTimeouts = new ConcurrentHashMap<MethodIdentifier, AccessTimeout>();
    private final Set<MethodIdentifier> asynchronousMethods = new HashSet<MethodIdentifier>();
    private final Set<String> asynchronousViews = new HashSet<String>();
    private String mappedName;
    private MethodIdentifier timeoutMethodIdentifier;
    private final Map<MethodIdentifier, List<AutoTimer>> scheduleMethodIdentifiers = new HashMap<MethodIdentifier, List<AutoTimer>>();
    private final Map<Method, List<AutoTimer>> scheduleMethods = new IdentityHashMap<Method, List<AutoTimer>>();
    private Method timeoutMethod;

    public SessionBeanComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName);
        this.addSetSessionContextMethodInvocationInterceptor();
    }

    public abstract boolean allowsConcurrentAccess();

    public void addLocalBusinessInterfaceViews(Collection<String> classNames) {
        for (String viewClassName : classNames) {
            this.assertNoRemoteView(viewClassName);
            this.registerView(viewClassName, MethodIntf.LOCAL);
        }
    }

    public void addLocalBusinessInterfaceViews(String ... classNames) {
        this.addLocalBusinessInterfaceViews(Arrays.asList(classNames));
    }

    public void addNoInterfaceView() {
        this.noInterfaceViewPresent = true;
        EJBViewDescription viewDescription = this.registerView(this.getEJBClassName(), MethodIntf.LOCAL);
        viewDescription.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    if (Modifier.isPublic(method.getModifiers())) continue;
                    configuration.addViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new NotBusinessMethodInterceptor(method)), 0);
                }
            }
        });
    }

    public EJBViewDescription addWebserviceEndpointView() {
        return this.registerView(this.getEJBClassName(), MethodIntf.SERVICE_ENDPOINT);
    }

    public void addRemoteBusinessInterfaceViews(Collection<String> classNames) {
        for (String viewClassName : classNames) {
            this.assertNoLocalView(viewClassName);
            this.registerView(viewClassName, MethodIntf.REMOTE);
        }
    }

    private void assertNoRemoteView(String viewClassName) {
        EJBViewDescription ejbView = null;
        for (ViewDescription view : this.getViews()) {
            ejbView = (EJBViewDescription)view;
            if (!viewClassName.equals(ejbView.getViewClassName()) || ejbView.getMethodIntf() != MethodIntf.REMOTE) continue;
            throw new IllegalStateException("[EJB 3.1 spec, section 4.9.7] - Can't add view class: " + viewClassName + " as local view since it's already marked as remote view for bean: " + this.getEJBName());
        }
    }

    private void assertNoLocalView(String viewClassName) {
        EJBViewDescription ejbView = null;
        for (ViewDescription view : this.getViews()) {
            ejbView = (EJBViewDescription)view;
            if (!viewClassName.equals(ejbView.getViewClassName()) || ejbView.getMethodIntf() != MethodIntf.LOCAL) continue;
            throw new IllegalStateException("[EJB 3.1 spec, section 4.9.7] - Can't add view class: " + viewClassName + " as remote view since it's already marked as local view for bean: " + this.getEJBName());
        }
    }

    public boolean hasNoInterfaceView() {
        return this.noInterfaceViewPresent;
    }

    public void setBeanLevelLockType(String className, LockType locktype) {
        this.beanLevelLockType.put(className, locktype);
    }

    public Map<String, LockType> getBeanLevelLockType() {
        return this.beanLevelLockType;
    }

    public void setLockType(LockType lockType, MethodIdentifier method) {
        this.methodLockTypes.put(method, lockType);
    }

    public Map<MethodIdentifier, LockType> getMethodApplicableLockTypes() {
        return this.methodLockTypes;
    }

    public Map<String, AccessTimeout> getBeanLevelAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public void setBeanLevelAccessTimeout(String className, AccessTimeout accessTimeout) {
        this.beanLevelAccessTimeout.put(className, accessTimeout);
    }

    public void setAccessTimeout(AccessTimeout accessTimeout, MethodIdentifier method) {
        this.methodAccessTimeouts.put(method, accessTimeout);
    }

    public Map<MethodIdentifier, AccessTimeout> getMethodApplicableAccessTimeouts() {
        return this.methodAccessTimeouts;
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        return this.concurrencyManagementType;
    }

    public void beanManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.BEAN) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.BEAN;
    }

    public void containerManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.CONTAINER) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.CONTAINER;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public void addAsynchronousMethod(MethodIdentifier methodIdentifier) {
        this.asynchronousMethods.add(methodIdentifier);
    }

    public void addAsynchronousView(String viewName) {
        this.asynchronousViews.add(viewName);
    }

    public abstract SessionBeanType getSessionBeanType();

    @Override
    protected void setupViewInterceptors(ViewDescription view) {
        super.setupViewInterceptors(view);
        SessionBeanComponentDescription.addTxManagementInterceptorForView(view);
    }

    protected static void addTxManagementInterceptorForView(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
                if (TransactionManagementType.CONTAINER.equals((Object)ejbComponentDescription.getTransactionManagementType())) {
                    configuration.addViewInterceptor((InterceptorFactory)CMTTxInterceptorFactory.INSTANCE, 1024);
                }
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addPostConstructInterceptor(SessionInvocationContextInterceptor.LIFECYCLE_FACTORY, 512);
                configuration.addPreDestroyInterceptor(SessionInvocationContextInterceptor.LIFECYCLE_FACTORY, 512);
            }
        });
    }

    private void addSetSessionContextMethodInvocationInterceptor() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                if (SessionBean.class.isAssignableFrom(configuration.getComponentClass())) {
                    configuration.addPostConstructInterceptor(SessionBeanSetSessionContextMethodInvocationInterceptor.FACTORY, 2048);
                }
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptor(SessionInvocationContextInterceptor.FACTORY, 768);
            }
        });
    }

    @Override
    public boolean isSingleton() {
        return this.getSessionBeanType() == SessionBeanType.SINGLETON;
    }

    @Override
    public boolean isStateful() {
        return this.getSessionBeanType() == SessionBeanType.STATEFUL;
    }

    @Override
    public boolean isStateless() {
        return this.getSessionBeanType() == SessionBeanType.STATELESS;
    }

    public MethodIdentifier getTimeoutMethodIdentifier() {
        return this.timeoutMethodIdentifier;
    }

    public void setTimeoutMethodIdentifier(MethodIdentifier timeoutMethodIdentifier) {
        this.timeoutMethodIdentifier = timeoutMethodIdentifier;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public void setTimeoutMethod(Method timeoutMethod) {
        this.timeoutMethod = timeoutMethod;
    }

    public Map<MethodIdentifier, List<AutoTimer>> getScheduleMethodIdentifiers() {
        return Collections.unmodifiableMap(this.scheduleMethodIdentifiers);
    }

    public void addScheduleMethodIdentifier(MethodIdentifier identifier, AutoTimer timer) {
        List<AutoTimer> schedules = this.scheduleMethodIdentifiers.get(identifier);
        if (schedules == null) {
            schedules = new ArrayList<AutoTimer>(1);
            this.scheduleMethodIdentifiers.put(identifier, schedules);
        }
        schedules.add(timer);
    }

    public Map<Method, List<AutoTimer>> getScheduleMethods() {
        return Collections.unmodifiableMap(this.scheduleMethods);
    }

    public void addScheduleMethod(Method method, AutoTimer timer) {
        List<AutoTimer> schedules = this.scheduleMethods.get(method);
        if (schedules == null) {
            schedules = new ArrayList<AutoTimer>(1);
            this.scheduleMethods.put(method, schedules);
        }
        schedules.add(timer);
    }

    public static enum SessionBeanType {
        STATELESS,
        STATEFUL,
        SINGLETON;

    }
}

