/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.NoSuchEJBException;
import org.jboss.as.ejb3.component.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class StatefulComponentInstanceDestroyInterceptor
extends AbstractEJBInterceptor {
    private static final Logger log = Logger.getLogger(StatefulComponentInstanceDestroyInterceptor.class);
    private final AtomicReference<Serializable> sessionIdReference;

    public StatefulComponentInstanceDestroyInterceptor(AtomicReference<Serializable> sessionIdReference) {
        this.sessionIdReference = sessionIdReference;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulComponentInstanceDestroyInterceptor.getComponent(context, StatefulSessionComponent.class);
        Serializable sessionId = this.sessionIdReference.get();
        if (sessionId == null) {
            throw new IllegalStateException("Session id hasn't been set for stateful component: " + component.getComponentName());
        }
        log.debug((Object)("Looking for stateful component instance with session id: " + sessionId));
        try {
            StatefulSessionComponentInstance instance = (StatefulSessionComponentInstance)component.getCache().get(sessionId);
        }
        catch (NoSuchEJBException nsee) {
            log.info((Object)("Could not find stateful session bean instance with id: " + sessionId + " for bean: " + component.getComponentName() + " during destruction. Probably already removed"));
            return null;
        }
        component.getCache().remove(sessionId);
        return null;
    }
}

