/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class AroundTimeoutAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName AROUND_TIMEOUT_ANNOTATION_NAME = DotName.createSimple((String)AroundTimeout.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        List aroundInvokes = index.getAnnotations(AROUND_TIMEOUT_ANNOTATION_NAME);
        for (AnnotationInstance annotation : aroundInvokes) {
            this.processAroundInvoke(annotation.target(), applicationClasses);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processAroundInvoke(AnnotationTarget target, EEApplicationClasses applicationClasses) {
        if (!(target instanceof MethodInfo)) {
            throw new IllegalArgumentException("@AroundTimeout is only valid on method targets.");
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        ClassInfo classInfo = methodInfo.declaringClass();
        EEModuleClassDescription classDescription = applicationClasses.getOrAddClassByName(classInfo.name().toString());
        this.validateArgumentType(classInfo, methodInfo);
        classDescription.setAroundTimeoutMethod(MethodIdentifier.getIdentifier(Object.class, (String)methodInfo.name(), (Class[])new Class[]{InvocationContext.class}));
    }

    private void validateArgumentType(ClassInfo classInfo, MethodInfo methodInfo) {
        Type[] args = methodInfo.args();
        switch (args.length) {
            case 0: {
                throw new IllegalArgumentException("Invalid argument signature.  Methods annotated with " + AROUND_TIMEOUT_ANNOTATION_NAME + " must have a single InvocationContext argument.");
            }
            case 1: {
                if (InvocationContext.class.getName().equals(args[0].name().toString())) break;
                throw new IllegalArgumentException("Invalid argument type.  Methods annotated with " + AROUND_TIMEOUT_ANNOTATION_NAME + " must have a single InvocationContext argument.");
            }
            default: {
                throw new IllegalArgumentException("Invalid number of arguments for method " + methodInfo.name() + " annotated with " + AROUND_TIMEOUT_ANNOTATION_NAME + " on class " + classInfo.name());
            }
        }
        if (!methodInfo.returnType().name().toString().equals(Object.class.getName())) {
            throw new IllegalArgumentException("@AroundTimeout methods must have an Object return type for " + methodInfo.name() + " annotated with " + AROUND_TIMEOUT_ANNOTATION_NAME + " on class " + classInfo.name());
        }
    }
}

