/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.operations;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.PropertiesCallbackHandler;
import org.jboss.as.domain.management.security.SSLIdentityService;
import org.jboss.as.domain.management.security.SecretIdentityService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class SecurityRealmAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) {
        ModelNode serverIdentities;
        ModelNode authentication = operation.hasDefined("authentication") ? operation.get("authentication") : null;
        ModelNode modelNode = serverIdentities = operation.hasDefined("server-identities") ? operation.get("server-identities") : null;
        if (serverIdentities != null) {
            model.get("server-identities").set(serverIdentities);
        }
        if (authentication != null) {
            model.get("authentication").set(authentication);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER || context.getType() == OperationContext.Type.HOST;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String realmName = address.getLastElement().getValue();
        ModelNode authentication = operation.hasDefined("authentication") ? operation.get("authentication") : null;
        ModelNode serverIdentities = operation.hasDefined("server-identities") ? operation.get("server-identities") : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        SecurityRealmService securityRealmService = new SecurityRealmService(realmName);
        ServiceName realmServiceName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName});
        ServiceBuilder realmBuilder = serviceTarget.addService(realmServiceName, (Service)securityRealmService);
        ServiceName authenticationName = null;
        if (authentication != null) {
            if (authentication.hasDefined("ldap")) {
                authenticationName = this.addLdapService(authentication.require("ldap"), realmServiceName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("properties")) {
                authenticationName = this.addPropertiesService(authentication.require("properties"), realmServiceName, realmName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("users")) {
                authenticationName = this.addUsersService(authentication.require("users"), realmServiceName, realmName, serviceTarget, newControllers);
            }
        }
        if (authenticationName != null) {
            realmBuilder.addDependency(authenticationName, DomainCallbackHandler.class, securityRealmService.getCallbackHandlerInjector());
        }
        if (serverIdentities != null) {
            if (serverIdentities.hasDefined("ssl")) {
                ServiceName sslServiceName = this.addSSLService(serverIdentities.require("ssl"), realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(sslServiceName, SSLIdentityService.class, securityRealmService.getSSLIdentityInjector());
            }
            if (serverIdentities.hasDefined("secret")) {
                ServiceName secretServiceName = this.addSecretService(serverIdentities.require("secret"), realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(secretServiceName, CallbackHandlerFactory.class, securityRealmService.getSecretCallbackFactory());
            }
        }
        newControllers.add(realmBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    private ServiceName addLdapService(ModelNode ldap, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName ldapServiceName = realmServiceName.append(new String[]{"ldap"});
        UserLdapCallbackHandler ldapCallbackHandler = new UserLdapCallbackHandler(ldap);
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapServiceName, (Service)ldapCallbackHandler);
        String connectionManager = ldap.require("connection").asString();
        ldapBuilder.addDependency(LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{connectionManager}), ConnectionManager.class, ldapCallbackHandler.getConnectionManagerInjector());
        newControllers.add(ldapBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return ldapServiceName;
    }

    private ServiceName addPropertiesService(ModelNode properties, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName propsServiceName = realmServiceName.append(new String[]{"properties"});
        PropertiesCallbackHandler propsCallbackHandler = new PropertiesCallbackHandler(realmName, properties);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsCallbackHandler);
        if (properties.hasDefined("relative-to")) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(properties.get("relative-to").asString()), String.class, propsCallbackHandler.getRelativeToInjector());
        }
        newControllers.add(propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return propsServiceName;
    }

    private ServiceName addSSLService(ModelNode ssl, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName sslServiceName = realmServiceName.append(new String[]{"ssl"});
        SSLIdentityService sslIdentityService = new SSLIdentityService(ssl);
        ServiceBuilder sslBuilder = serviceTarget.addService(sslServiceName, (Service)sslIdentityService);
        if (ssl.hasDefined("keystore") && ssl.get("keystore").hasDefined("relative-to")) {
            sslBuilder.addDependency(SecurityRealmAddHandler.pathName(ssl.get(new String[]{"keystore", "relative-to"}).asString()), String.class, sslIdentityService.getRelativeToInjector());
        }
        newControllers.add(sslBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return sslServiceName;
    }

    private ServiceName addSecretService(ModelNode secret, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName secretServiceName = realmServiceName.append(new String[]{"secret"});
        String secretValue = secret.require("value").asString();
        SecretIdentityService sis = new SecretIdentityService(secretValue);
        serviceTarget.addService(secretServiceName, (Service)sis).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return secretServiceName;
    }

    private ServiceName addUsersService(ModelNode users, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName usersServiceName = realmServiceName.append(new String[]{"users"});
        UserDomainCallbackHandler usersCallbackHandler = new UserDomainCallbackHandler(realmName, users);
        ServiceBuilder usersBuilder = serviceTarget.addService(usersServiceName, (Service)usersCallbackHandler);
        newControllers.add(usersBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return usersServiceName;
    }

    private static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }
}

