/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.ThreadDecorator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;

public class TimerSchedulerAdapter
implements TimeScheduler {
    final ScheduledExecutorService executor;

    public TimerSchedulerAdapter(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public ThreadDecorator getThreadDecorator() {
        return null;
    }

    public void setThreadDecorator(ThreadDecorator decorator) {
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public Future<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    public Future<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public Future<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public Future<?> scheduleWithDynamicInterval(final TimeScheduler.Task task) {
        final ScheduledFuture<?> future = this.executor.schedule((Runnable)task, task.nextInterval(), TimeUnit.MILLISECONDS);
        final long nextInterval = task.nextInterval();
        if (nextInterval > 0L) {
            Runnable scheduleTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        future.get();
                        long interval = nextInterval;
                        while (interval > 0L && !future.isCancelled() && !Thread.currentThread().isInterrupted()) {
                            try {
                                TimerSchedulerAdapter.this.executor.schedule((Runnable)task, interval, TimeUnit.MILLISECONDS).get();
                            }
                            catch (ExecutionException executionException) {
                                // empty catch block
                            }
                            interval = task.nextInterval();
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            this.execute(scheduleTask);
        }
        return future;
    }

    public void setThreadFactory(ThreadFactory factory) {
    }

    public String dumpTimerTasks() {
        return this.getThreadPool().getQueue().toString();
    }

    public int getMinThreads() {
        return this.getThreadPool().getCorePoolSize();
    }

    public void setMinThreads(int size) {
    }

    public int getMaxThreads() {
        return this.getThreadPool().getMaximumPoolSize();
    }

    public void setMaxThreads(int size) {
    }

    public long getKeepAliveTime() {
        return this.getThreadPool().getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveTime(long time) {
    }

    public int getCurrentThreads() {
        return this.getThreadPool().getActiveCount();
    }

    public int size() {
        return this.getThreadPool().getPoolSize();
    }

    public void stop() {
        this.executor.shutdown();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    private ThreadPoolExecutor getThreadPool() {
        return TimerSchedulerAdapter.getThreadPool(this.executor);
    }

    private static ThreadPoolExecutor getThreadPool(Executor executor) {
        if (executor instanceof ThreadPoolExecutor) {
            return (ThreadPoolExecutor)executor;
        }
        final Field field = TimerSchedulerAdapter.getField(executor.getClass(), Executor.class);
        if (field != null) {
            PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            };
            AccessController.doPrivileged(action);
            try {
                return TimerSchedulerAdapter.getThreadPool((Executor)field.get(executor));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static <T> Field getField(Class<? extends T> targetClass, Class<T> fieldClass) {
        for (Field field : targetClass.getDeclaredFields()) {
            if (!fieldClass.isAssignableFrom(field.getType())) continue;
            return field;
        }
        Class<T> superClass = targetClass.getSuperclass();
        return superClass != null && fieldClass.isAssignableFrom(superClass) ? TimerSchedulerAdapter.getField(superClass.asSubclass(fieldClass), fieldClass) : null;
    }
}

