/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;

public final class LicenseServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    static final String[] LICENSE_FILES = new String[]{"README", "DISCLAIMER", "LICENSE", "NOTICE", "DEPENDENCIES"};
    static final String LABEL = "licenses";
    static final String TITLE = "%licenses.pluginTitle";
    static final String[] CSS = new String[]{"/res/ui/license.css"};
    private final String TEMPLATE = this.readTemplateFile("/templates/license.html");

    public LicenseServlet() {
        super(LABEL, TITLE, CSS);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PathInfo pathInfo = PathInfo.parse(request.getPathInfo());
        if (pathInfo != null) {
            if (!this.sendResource(pathInfo, response)) {
                // empty if block
            }
        } else {
            super.doGet(request, response);
        }
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse res) throws IOException {
        Bundle[] bundles = this.getBundleContext().getBundles();
        Util.sort(bundles, request.getLocale());
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("__data__", LicenseServlet.getBundleData(bundles, request.getLocale()).toString());
        res.getWriter().print(this.TEMPLATE);
    }

    private static final JSONArray getBundleData(Bundle[] bundles, Locale locale) throws IOException {
        JSONArray ret = new JSONArray();
        try {
            for (int i = 0; i < bundles.length; ++i) {
                Bundle bundle = bundles[i];
                JSONObject files = LicenseServlet.findResource(bundle, LICENSE_FILES);
                LicenseServlet.addLicensesFromHeader(bundle, files);
                if (files.length() <= 0) continue;
                JSONObject data = new JSONObject();
                data.put("bid", bundle.getBundleId());
                data.put("title", (Object)Util.getName(bundle, locale));
                data.put("files", (Object)files);
                ret.put((Object)data);
            }
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
        return ret;
    }

    private static final String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static final JSONObject addLicensesFromHeader(Bundle bundle, JSONObject files) throws JSONException {
        String target = (String)bundle.getHeaders("").get("Bundle-License");
        if (target != null) {
            Clause[] licenses = Parser.parseHeader(target);
            for (int i = 0; licenses != null && i < licenses.length; ++i) {
                String url;
                String path;
                String name = licenses[i].getName();
                if ("<<EXTERNAL>>".equals(name)) continue;
                String link = licenses[i].getAttribute("link");
                if (link == null) {
                    path = name;
                    url = LicenseServlet.getName(name);
                } else {
                    path = link;
                    url = name;
                }
                if (path.indexOf("://") == -1 && null == bundle.getEntry(path)) continue;
                JSONObject entry = new JSONObject();
                entry.put("path", (Object)path);
                entry.put("url", (Object)url);
                files.append("__res__", (Object)entry);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JSONObject findResource(Bundle bundle, String[] patterns) throws IOException, JSONException {
        JSONObject ret = new JSONObject();
        for (int i = 0; i < patterns.length; ++i) {
            Enumeration entries = bundle.findEntries("/", patterns[i] + "*", true);
            if (entries == null) continue;
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                JSONObject entry = new JSONObject();
                entry.put("path", (Object)url.getPath());
                entry.put("url", (Object)LicenseServlet.getName(url.getPath()));
                ret.append("__res__", (Object)entry);
            }
        }
        Enumeration entries = bundle.findEntries("/", "*.jar", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                String resName = LicenseServlet.getName(url.getPath());
                InputStream ins = null;
                try {
                    ins = url.openStream();
                    ZipInputStream zin = new ZipInputStream(ins);
                    ZipEntry zentry = zin.getNextEntry();
                    while (zentry != null) {
                        String name = zentry.getName();
                        if (!name.endsWith("/")) {
                            name = name.substring(name.lastIndexOf(47) + 1);
                            for (int i = 0; i < patterns.length; ++i) {
                                if (!name.startsWith(patterns[i])) continue;
                                JSONObject entry = new JSONObject();
                                entry.put("jar", (Object)url.getPath());
                                entry.put("path", (Object)zentry.getName());
                                entry.put("url", (Object)LicenseServlet.getName(name));
                                ret.append(resName, (Object)entry);
                            }
                        }
                        zentry = zin.getNextEntry();
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)ins);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendResource(PathInfo pathInfo, HttpServletResponse response) throws IOException {
        block13: {
            Bundle bundle;
            block12: {
                String name = pathInfo.licenseFile.substring(pathInfo.licenseFile.lastIndexOf(47) + 1);
                boolean isLicense = false;
                for (int i = 0; !isLicense && i < LICENSE_FILES.length; ++i) {
                    isLicense = name.startsWith(LICENSE_FILES[i]);
                }
                bundle = this.getBundleContext().getBundle(pathInfo.bundleId);
                if (bundle == null) {
                    return false;
                }
                WebConsoleUtil.setNoCache(response);
                response.setContentType("text/plain");
                if (pathInfo.innerJar != null) break block12;
                URL resource = bundle.getResource(pathInfo.licenseFile);
                if (resource != null) {
                    InputStream input = resource.openStream();
                    try {
                        IOUtils.copy((InputStream)input, (Writer)response.getWriter());
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)input);
                    }
                }
                break block13;
            }
            URL zipResource = bundle.getResource(pathInfo.innerJar);
            if (zipResource != null) {
                boolean bl;
                ZipEntry zentry;
                InputStream input = zipResource.openStream();
                ZipInputStream zin = null;
                try {
                    zin = new ZipInputStream(input);
                    zentry = zin.getNextEntry();
                    while (zentry != null) {
                        if (!pathInfo.licenseFile.equals(zentry.getName())) break block11;
                        IOUtils.copy((InputStream)zin, (Writer)response.getWriter());
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zin);
                    IOUtils.closeQuietly((InputStream)input);
                    throw throwable;
                }
                {
                    block11: {
                        IOUtils.closeQuietly((InputStream)zin);
                        IOUtils.closeQuietly((InputStream)input);
                        return bl;
                    }
                    zentry = zin.getNextEntry();
                    continue;
                }
                IOUtils.closeQuietly((InputStream)zin);
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        return false;
    }

    static class PathInfo {
        final long bundleId;
        final String innerJar;
        final String licenseFile;

        static PathInfo parse(String pathInfo) {
            String innerJar;
            long bundleId;
            if (pathInfo == null || pathInfo.length() == 0 || !pathInfo.startsWith("/licenses/")) {
                return null;
            }
            String parts = pathInfo.substring(LicenseServlet.LABEL.length() + 2);
            int slash = parts.indexOf(47);
            if (slash <= 0) {
                return null;
            }
            try {
                bundleId = Long.parseLong(parts.substring(0, slash));
                if (bundleId < 0L) {
                    return null;
                }
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            int jarSep = parts.indexOf("!/", slash);
            if (jarSep < 0) {
                innerJar = null;
            } else {
                innerJar = parts.substring(slash, jarSep);
                slash = jarSep + 2;
            }
            String licenseFile = parts.substring(slash);
            return new PathInfo(bundleId, innerJar, licenseFile);
        }

        private PathInfo(long bundleId, String innerJar, String licenseFile) {
            this.bundleId = bundleId;
            this.innerJar = innerJar;
            this.licenseFile = licenseFile;
        }
    }
}

