/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.managedbean.processors;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ManagedBean;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.EEResourceReferenceProcessorRegistry;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.managedbean.component.ManagedBeanAssociatingInterceptorFactory;
import org.jboss.as.ee.managedbean.component.ManagedBeanCreateInterceptorFactory;
import org.jboss.as.ee.managedbean.component.ManagedBeanDestroyInterceptorFactory;
import org.jboss.as.ee.managedbean.component.ManagedBeanResourceReferenceProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class ManagedBeanAnnotationProcessor
implements DeploymentUnitProcessor {
    static final DotName MANAGED_BEAN_ANNOTATION_NAME = DotName.createSimple((String)ManagedBean.class.getName());
    private static final Logger logger = Logger.getLogger(ManagedBeanAnnotationProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        List instances = compositeIndex.getAnnotations(MANAGED_BEAN_ANNOTATION_NAME);
        if (instances == null || instances.isEmpty()) {
            return;
        }
        for (AnnotationInstance instance : instances) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) {
                throw new DeploymentUnitProcessingException("The ManagedBean annotation is only allowed at the class level: " + target);
            }
            ClassInfo classInfo = (ClassInfo)target;
            if (!ManagedBeanAnnotationProcessor.assertManagedBeanClassValidity(classInfo)) continue;
            String beanClassName = classInfo.name().toString();
            AnnotationValue nameValue = instance.value();
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? beanClassName : nameValue.asString();
            ComponentDescription componentDescription = new ComponentDescription(beanName, beanClassName, moduleDescription, applicationClasses.getOrAddClassByName(beanClassName), deploymentUnit.getServiceName(), applicationClasses);
            ViewDescription viewDescription = new ViewDescription(componentDescription, beanClassName);
            viewDescription.getConfigurators().addFirst(new ViewConfigurator(){

                @Override
                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    Object contextKey = new Object();
                    configuration.addViewPostConstructInterceptor(new ManagedBeanCreateInterceptorFactory(contextKey), 256);
                    ManagedBeanAssociatingInterceptorFactory associatingInterceptorFactory = new ManagedBeanAssociatingInterceptorFactory(contextKey);
                    configuration.addViewInterceptor(associatingInterceptorFactory, 1280);
                    configuration.addViewPreDestroyInterceptor(new ManagedBeanDestroyInterceptorFactory(contextKey), 256);
                }
            });
            viewDescription.getBindingNames().addAll(Arrays.asList("java:module/" + beanName, "java:app/" + moduleDescription.getModuleName() + "/" + beanName));
            componentDescription.getViews().add(viewDescription);
            moduleDescription.addComponent(componentDescription);
            EEResourceReferenceProcessorRegistry.registerResourceReferenceProcessor(new ManagedBeanResourceReferenceProcessor(beanClassName));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static boolean assertManagedBeanClassValidity(ClassInfo managedBeanClass) {
        short flags = managedBeanClass.flags();
        String className = managedBeanClass.name().toString();
        if (Modifier.isInterface(flags)) {
            logger.warn((Object)("[Managed Bean spec, section MB.2.1.1] Managed bean implementation class MUST NOT be a interface - " + className + " is an interface, hence won't be considered as a managed bean"));
            return false;
        }
        if (Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            logger.warn((Object)("[Managed Bean spec, section MB.2.1.1] Managed bean implementation class MUST NOT be abstract or final - " + className + " won't be considered as a managed bean, since it doesn't meet that requirement"));
            return false;
        }
        return true;
    }
}

