/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jms;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class DeleteJmsResourceHandler
extends BatchModeCommandHandler {
    public DeleteJmsResourceHandler() {
        super("delete-jms-resource", true);
        this.addRequiredPath("/subsystem=messaging");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        String resource;
        try {
            if (!ctx.getParsedArguments().hasArguments()) {
                throw new OperationFormatException("Arguments are missing");
            }
        }
        catch (CommandFormatException e) {
            throw new OperationFormatException(e.getLocalizedMessage());
        }
        String jndiName = null;
        String[] args = ctx.getArgumentsString().split("\\s+");
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("--target")) continue;
            jndiName = arg;
        }
        if (jndiName == null) {
            throw new OperationFormatException("name is missing.");
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (Util.isTopic(client, jndiName)) {
            resource = "jms-topic";
        } else if (Util.isQueue(client, jndiName)) {
            resource = "jms-queue";
        } else if (Util.isConnectionFactory(client, jndiName)) {
            resource = "connection-factory";
        } else {
            throw new OperationFormatException("'" + jndiName + "' wasn't found among existing JMS resources.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.addNode("subsystem", "messaging");
        builder.addNode(resource, jndiName);
        builder.setOperationName("remove");
        return builder.buildRequest();
    }
}

