/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionParsingContextImpl;
import org.jboss.as.controller.parsing.JvmType;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class CommonXml
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<ModelMarshallingContext> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    protected static final Set<String> RESTRICTED_PATHS;
    protected final ModuleLoader moduleLoader;

    protected CommonXml(ModuleLoader loader) {
        this.moduleLoader = loader;
    }

    protected String getDefaultName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to determine a default name based on the local host name", e);
        }
    }

    protected void parseNamespaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null || prefix.length() <= 0) continue;
            ModelNode operation = new ModelNode();
            operation.get("address").set(address);
            operation.get("operation").set("add-namespace");
            operation.get("namespace").set(prefix, reader.getNamespaceURI(i));
            nodes.add(operation);
        }
    }

    protected void readHeadComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void readTailComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void parseSchemaLocations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updateList, int idx) throws XMLStreamException {
        List elements = reader.getListAttributeValue(idx);
        ArrayList<String> values = new ArrayList<String>();
        for (String element : elements) {
            if (element.trim().isEmpty()) continue;
            values.add(element);
        }
        if ((values.size() & 1) != 0) {
            throw ParseUtils.invalidAttributeValue(reader, idx);
        }
        Iterator it = values.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)it.next();
            if (key.length() <= 0 || val.length() <= 0) continue;
            ModelNode update = new ModelNode();
            update.get("address").set(address);
            update.get("operation").set("add-schema-location");
            update.get("schema-location").set(key, val);
            updateList.add(update);
        }
    }

    protected void writeSchemaLocation(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (!modelNode.hasDefined("schema-locations")) {
            return;
        }
        StringBuilder b = new StringBuilder();
        Iterator iterator = modelNode.get("schema-locations").asList().iterator();
        while (iterator.hasNext()) {
            ModelNode location = (ModelNode)iterator.next();
            Property property = location.asProperty();
            b.append(property.getName()).append(' ').append(property.getValue().asString());
            if (!iterator.hasNext()) continue;
            b.append(' ');
        }
        if (b.length() > 0) {
            writer.writeAttribute(Namespace.XML_SCHEMA_INSTANCE.getUriString(), Attribute.SCHEMA_LOCATION.getLocalName(), b.toString());
        }
    }

    protected void writeNamespaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (!modelNode.hasDefined("namespaces")) {
            return;
        }
        for (Property property : modelNode.get("namespaces").asPropertyList()) {
            writer.writeNamespace(property.getName(), property.getValue().asString());
        }
    }

    protected static void writeElement(XMLExtendedStreamWriter writer, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
    }

    protected void writeExtensions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set keys = modelNode.keys();
        if (keys.size() > 0) {
            writer.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (String extension : keys) {
                writer.writeEmptyElement(Element.EXTENSION.getLocalName());
                writer.writeAttribute(Attribute.MODULE.getLocalName(), extension);
            }
            writer.writeEndElement();
        }
    }

    protected void writePaths(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List paths = node.asPropertyList();
        if (paths.size() > 0) {
            writer.writeStartElement(Element.PATHS.getLocalName());
            for (Property path : paths) {
                ModelNode value = path.getValue();
                writer.writeEmptyElement(Element.PATH.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), path.getName());
                writer.writeAttribute(Attribute.PATH.getLocalName(), value.get("path").asString());
                if (!value.has("relative-to") || !value.get("relative-to").isDefined()) continue;
                writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), value.get("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    protected void parseExtensions(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> found = new HashSet<String>();
        ExtensionParsingContextImpl context = new ExtensionParsingContextImpl(reader.getXMLMapper());
        while (reader.hasNext() && reader.nextTag() != 2) {
            String moduleName = ParseUtils.readStringAttributeElement(reader, Attribute.MODULE.getLocalName());
            if (!found.add(moduleName)) {
                throw ParseUtils.invalidAttributeValue(reader, 0);
            }
            try {
                Module module = this.moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
                boolean initialized = false;
                for (Extension extension : module.loadService(Extension.class)) {
                    extension.initializeParsers(context);
                    if (initialized) continue;
                    initialized = true;
                }
                if (!initialized) {
                    throw new IllegalStateException("No META-INF/services/" + Extension.class.getName() + " found for " + module.getIdentifier());
                }
                ModelNode add = new ModelNode();
                add.get("address").set(address).add("extension", moduleName);
                add.get("operation").set("add");
                list.add(add);
            }
            catch (ModuleLoadException e) {
                throw new XMLStreamException("Failed to load module", e);
            }
        }
    }

    protected void parseFSBaseType(XMLExtendedStreamReader reader, ModelNode parent, boolean isArchive) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        content.get("archive").set(isArchive);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case PATH: {
                    content.get("path").set(value);
                    continue block4;
                }
                case RELATIVE_TO: {
                    content.get("relative-to").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parsePaths(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requirePath) throws XMLStreamException {
        HashSet<String> pathNames = new HashSet<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PATH: {
                            this.parsePath(reader, address, list, requirePath, pathNames);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean allowInterfaces) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SECURITY_REALMS: {
                            if (++securityRealmsCount > 1) {
                                throw ParseUtils.unexpectedElement(reader);
                            }
                            this.parseSecurityRealms(reader, managementAddress, list);
                            continue block8;
                        }
                        case OUTBOUND_CONNECTIONS: {
                            if (++connectionsCount > 1) {
                                throw ParseUtils.unexpectedElement(reader);
                            }
                            this.parseConnections(reader, managementAddress, list);
                            continue block8;
                        }
                        case MANAGEMENT_INTERFACES: {
                            if (allowInterfaces) {
                                if (++managementInterfacesCount > 1) {
                                    throw ParseUtils.unexpectedElement(reader);
                                }
                                this.parseManagementInterfaces(reader, managementAddress, list);
                                continue block8;
                            }
                            String msg = String.format("Element %s is not supported in a domain.xml file", element.getLocalName());
                            log.warn((Object)ParseUtils.getWarningMessage(msg, reader.getLocation()));
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LDAP: {
                            this.parseLdapConnection(reader, address, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseLdapConnection(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String url = null;
        String searchDN = null;
        String searchCredential = null;
        String initialContextFactory = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case URL: {
                    url = value;
                    continue block7;
                }
                case SEARCH_DN: {
                    searchDN = value;
                    continue block7;
                }
                case SEARCH_CREDENTIAL: {
                    searchCredential = value;
                    continue block7;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    initialContextFactory = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        HashSet<Attribute> missingAttributes = new HashSet<Attribute>();
        if (name == null) {
            missingAttributes.add(Attribute.NAME);
        }
        if (url == null) {
            missingAttributes.add(Attribute.URL);
        }
        if (searchDN == null) {
            missingAttributes.add(Attribute.SEARCH_DN);
        }
        if (searchCredential == null) {
            missingAttributes.add(Attribute.SEARCH_CREDENTIAL);
        }
        if (missingAttributes.size() > 0) {
            throw ParseUtils.missingRequired(reader, missingAttributes);
        }
        ParseUtils.requireNoContent(reader);
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("outbound-connection", name);
        add.get("operation").set("add");
        add.get("type").set("ldap");
        add.get("url").set(url);
        add.get("search-dn").set(searchDN);
        add.get("search-credential").set(searchCredential);
        if (initialContextFactory != null) {
            add.get("initial-context-factory").set("initial-context-factory");
        }
        list.add(add);
    }

    protected void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SECURITY_REALM: {
                            this.parseSecurityRealm(reader, address, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseSecurityRealm(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("security-realm", realmName);
        add.get("operation").set("add");
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SERVER_IDENTITIES: {
                            this.parseServerIdentities(reader, add);
                            continue block7;
                        }
                        case AUTHENTICATION: {
                            this.parseAuthentication(reader, add);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        list.add(add);
    }

    protected void parseServerIdentities(XMLExtendedStreamReader reader, ModelNode securityRealmAdd) throws XMLStreamException {
        ModelNode serverIdentities = securityRealmAdd.get("server-identities");
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SECRET: {
                            this.parseSecret(reader, serverIdentities);
                            continue block7;
                        }
                        case SSL: {
                            this.parseSSL(reader, serverIdentities);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseSecret(XMLExtendedStreamReader reader, ModelNode serverIdentities) throws XMLStreamException {
        ModelNode secret = serverIdentities.get("secret");
        String secretValue = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    secretValue = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (secret == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        secret.get("value").set(secretValue);
    }

    protected void parseSSL(XMLExtendedStreamReader reader, ModelNode serverIdentities) throws XMLStreamException {
        ModelNode ssl = serverIdentities.get("ssl");
        String protocol = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    protocol = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (protocol != null) {
            ssl.get("protocol").set(protocol);
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case KEYSTORE: {
                            this.parseKeystore(reader, ssl);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseKeystore(XMLExtendedStreamReader reader, ModelNode securityRealmAdd) throws XMLStreamException {
        ModelNode keystore = securityRealmAdd.get("keystore");
        String password = null;
        String path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FILE: {
                    path = value;
                    continue block6;
                }
                case PATH: {
                    path = value;
                    continue block6;
                }
                case PASSWORD: {
                    password = value;
                    continue block6;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        HashSet<Attribute> missingAttributes = new HashSet<Attribute>();
        if (path == null) {
            missingAttributes.add(Attribute.PATH);
        }
        if (password == null) {
            missingAttributes.add(Attribute.PASSWORD);
        }
        if (missingAttributes.size() > 0) {
            throw ParseUtils.missingRequired(reader, missingAttributes);
        }
        ParseUtils.requireNoContent(reader);
        keystore.get("password").set(password);
        keystore.get("path").set(path);
        if (relativeTo != null) {
            keystore.get("relative-to").set(relativeTo);
        }
    }

    protected void parseAuthentication(XMLExtendedStreamReader reader, ModelNode securityRealmAdd) throws XMLStreamException {
        ModelNode authentication = securityRealmAdd.get("authentication");
        int userCount = 0;
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (++userCount > 1) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    switch (element) {
                        case LDAP: {
                            this.parseLdapAuthentication(reader, authentication);
                            continue block8;
                        }
                        case PROPERTIES: {
                            this.parsePropertiesAuthentication(reader, authentication);
                            continue block8;
                        }
                        case USERS: {
                            this.parseUsersAuthentication(reader, authentication);
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseLdapAuthentication(XMLExtendedStreamReader reader, ModelNode authentication) throws XMLStreamException {
        ModelNode ldapAuthentication = authentication.get("ldap");
        String connection = null;
        String baseDN = null;
        String usernameAttribute = null;
        String recursive = null;
        String userDN = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONNECTION: {
                    connection = value;
                    continue block7;
                }
                case BASE_DN: {
                    baseDN = value;
                    continue block7;
                }
                case USERNAME_ATTRIBUTE: {
                    usernameAttribute = value;
                    continue block7;
                }
                case RECURSIVE: {
                    recursive = value;
                    continue block7;
                }
                case USER_DN: {
                    userDN = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        HashSet<Attribute> missingAttributes = new HashSet<Attribute>();
        if (connection == null) {
            missingAttributes.add(Attribute.CONNECTION);
        }
        if (baseDN == null) {
            missingAttributes.add(Attribute.BASE_DN);
        }
        if (usernameAttribute == null) {
            missingAttributes.add(Attribute.USERNAME_ATTRIBUTE);
        }
        if (missingAttributes.size() > 0) {
            throw ParseUtils.missingRequired(reader, missingAttributes);
        }
        ParseUtils.requireNoContent(reader);
        ldapAuthentication.get("connection").set(connection);
        ldapAuthentication.get("base-dn").set(baseDN);
        ldapAuthentication.get("username-attribute").set(usernameAttribute);
        if (recursive != null) {
            ldapAuthentication.get("recursive").set(Boolean.valueOf(recursive).booleanValue());
        }
        if (userDN != null) {
            ldapAuthentication.get("user-dn").set(userDN);
        }
    }

    protected void parsePropertiesAuthentication(XMLExtendedStreamReader reader, ModelNode authentication) throws XMLStreamException {
        ModelNode properties = authentication.get("properties");
        String path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block4;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent(reader);
        properties.get("path").set(path);
        if (relativeTo != null) {
            properties.get("relative-to").set(relativeTo);
        }
    }

    protected void parseUsersAuthentication(XMLExtendedStreamReader reader, ModelNode authentication) throws XMLStreamException {
        ModelNode userDomain = authentication.get("users");
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case USER: {
                            this.parseUser(reader, userDomain);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseUser(XMLExtendedStreamReader reader, ModelNode userDomain) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, Attribute.USERNAME.getLocalName());
        String userName = reader.getAttributeValue(0);
        ModelNode user = userDomain.get(new String[]{"user", userName});
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PASSWORD: {
                            String password = reader.getElementText();
                            user.get("password").set(password);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parseManagementInterfaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case NATIVE_INTERFACE: {
                            this.parseNativeManagementInterface(reader, address, list);
                            continue block7;
                        }
                        case HTTP_INTERFACE: {
                            this.parseHttpManagementInterface(reader, address, list);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parsePath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requirePath, Set<String> defined) throws XMLStreamException {
        String name = null;
        String path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    if (RESTRICTED_PATHS.contains(value)) {
                        throw new XMLStreamException(name + " is reserved", reader.getLocation());
                    }
                    if (defined.add(name)) continue block5;
                    throw new XMLStreamException(name + " already defined", reader.getLocation());
                }
                case PATH: {
                    path = value;
                    continue block5;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (requirePath && path == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent(reader);
        ModelNode update = new ModelNode();
        update.get("address").set(address).add("path", name);
        update.get("operation").set("add");
        update.get("name").set(name);
        if (path != null) {
            update.get("path").set(path);
        }
        if (relativeTo != null) {
            update.get("relative-to").set(relativeTo);
        }
        list.add(update);
    }

    protected void parseSystemProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates, boolean standalone) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String name = null;
            String value = null;
            Boolean boottime = null;
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                String val = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (name != null) {
                            throw ParseUtils.duplicateAttribute(reader, "name");
                        }
                        name = val;
                        continue block6;
                    }
                    case VALUE: {
                        if (value != null) {
                            throw ParseUtils.duplicateAttribute(reader, "value");
                        }
                        value = val;
                        continue block6;
                    }
                    case BOOT_TIME: {
                        if (standalone) {
                            throw ParseUtils.unexpectedAttribute(reader, i);
                        }
                        boottime = Boolean.valueOf(val);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            ParseUtils.requireNoContent(reader);
            ModelNode propAddr = new ModelNode().set(address).add("system-property", name);
            ModelNode op = Util.getEmptyOperation("add", propAddr);
            op.get("value").set(value);
            if (boottime != null) {
                op.get("boot-time").set(boottime.booleanValue());
            }
            updates.add(op);
        }
    }

    protected ModelNode parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode properties = new ModelNode();
        while (reader.nextTag() != 2) {
            if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String[] array = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
            ParseUtils.requireNoContent(reader);
            properties.get(array[0]).set(array[1]);
        }
        return properties;
    }

    protected void parseHttpManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String interfaceName = null;
        int port = -1;
        int securePort = -1;
        int maxThreads = -1;
        String securityRealm = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    interfaceName = value;
                    continue block7;
                }
                case PORT: {
                    port = Integer.parseInt(value);
                    if (port >= 0) continue block7;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be negative", reader.getLocation());
                }
                case SECURE_PORT: {
                    securePort = Integer.parseInt(value);
                    if (securePort >= 0) continue block7;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + securePort + " -- cannot be negative", reader.getLocation());
                }
                case MAX_THREADS: {
                    maxThreads = Integer.parseInt(value);
                    if (maxThreads >= 1) continue block7;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + maxThreads + " -- must be greater than 0", reader.getLocation());
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (interfaceName == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("interface").set(interfaceName);
        if (port > -1) {
            mgmtSocket.get("port").set(port);
        }
        if (securePort > -1) {
            mgmtSocket.get("secure-port").set(securePort);
        }
        if (securityRealm != null) {
            mgmtSocket.get("security-realm").set(securityRealm);
        }
        mgmtSocket.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "http-interface");
        mgmtSocket.get("address").set(operationAddress);
        list.add(mgmtSocket);
        reader.discardRemainder();
    }

    private void parseNativeManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String interfaceName = null;
        int port = 0;
        String securityRealm = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    interfaceName = value;
                    continue block5;
                }
                case PORT: {
                    port = Integer.parseInt(value);
                    if (port >= 0) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be negative", reader.getLocation());
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (interfaceName == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("interface").set(interfaceName);
        mgmtSocket.get("port").set(port);
        if (securityRealm != null) {
            mgmtSocket.get("security-realm").set(securityRealm);
        }
        mgmtSocket.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "native-interface");
        mgmtSocket.get("address").set(operationAddress);
        list.add(mgmtSocket);
        reader.discardRemainder();
    }

    protected void parseJvm(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> updates, Set<String> jvmNames) throws XMLStreamException {
        this.parseJvm(reader, parentAddress, updates, jvmNames, false);
    }

    protected void parseJvm(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> updates, Set<String> jvmNames, boolean server) throws XMLStreamException {
        ArrayList<ModelNode> attrUpdates = new ArrayList<ModelNode>();
        String name = null;
        String type = null;
        String home = null;
        Boolean debugEnabled = null;
        String debugOptions = null;
        Boolean envClasspathIgnored = null;
        int count = reader.getAttributeCount();
        block23: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    if (!jvmNames.add(value)) {
                        throw new XMLStreamException("Duplicate JVM declaration " + value, reader.getLocation());
                    }
                    name = value;
                    continue block23;
                }
                case JAVA_HOME: {
                    if (home != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    home = value;
                    ModelNode update = Util.getWriteAttributeOperation(null, "java-home", home);
                    attrUpdates.add(update);
                    continue block23;
                }
                case TYPE: {
                    try {
                        Enum.valueOf(JvmType.class, value);
                        type = value;
                        continue block23;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue(reader, i);
                    }
                }
                case DEBUG_ENABLED: {
                    if (!server) {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                    if (debugEnabled != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    debugEnabled = Boolean.valueOf(value);
                    ModelNode update = Util.getWriteAttributeOperation(null, "debug-enabled", debugEnabled);
                    attrUpdates.add(update);
                    continue block23;
                }
                case DEBUG_OPTIONS: {
                    if (!server) {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                    if (debugOptions != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    debugOptions = value;
                    ModelNode update = Util.getWriteAttributeOperation(null, "debug-options", debugOptions);
                    attrUpdates.add(update);
                    continue block23;
                }
                case ENV_CLASSPATH_IGNORED: {
                    if (envClasspathIgnored != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    envClasspathIgnored = Boolean.valueOf(value);
                    ModelNode update = Util.getWriteAttributeOperation(null, "env-classpath-ignored", envClasspathIgnored);
                    attrUpdates.add(update);
                    continue block23;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (debugEnabled != null && debugOptions == null && debugEnabled.booleanValue()) {
            throw ParseUtils.missingRequired(reader, EnumSet.of(Attribute.DEBUG_OPTIONS));
        }
        ModelNode address = parentAddress.clone();
        address.add("jvm", name);
        ModelNode addUpdate = Util.getEmptyOperation("add", address);
        if (type != null) {
            addUpdate.get("type").set(type);
        }
        updates.add(addUpdate);
        for (ModelNode attrUpdate : attrUpdates) {
            attrUpdate.get("address").set(address);
            updates.add(attrUpdate);
        }
        boolean hasJvmOptions = false;
        boolean hasEnvironmentVariables = false;
        block25: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case HEAP: {
                            this.parseHeap(reader, address, updates);
                            continue block25;
                        }
                        case PERMGEN: {
                            this.parsePermgen(reader, address, updates);
                            continue block25;
                        }
                        case STACK: {
                            this.parseStack(reader, address, updates);
                            continue block25;
                        }
                        case AGENT_LIB: {
                            this.parseAgentLib(reader, address, updates);
                            continue block25;
                        }
                        case AGENT_PATH: {
                            this.parseAgentPath(reader, address, updates);
                            continue block25;
                        }
                        case JAVA_AGENT: {
                            this.parseJavaagent(reader, address, updates);
                            continue block25;
                        }
                        case ENVIRONMENT_VARIABLES: {
                            if (hasEnvironmentVariables) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            updates.add(Util.getWriteAttributeOperation(address, "environment-variables", this.parseProperties(reader)));
                            hasEnvironmentVariables = true;
                            continue block25;
                        }
                        case JVM_OPTIONS: {
                            if (hasJvmOptions) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            this.parseJvmOptions(reader, address, updates);
                            hasJvmOptions = true;
                            continue block25;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseHeap(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String size = null;
        String maxSize = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block4;
                }
                case MAX_SIZE: {
                    maxSize = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (size != null) {
            ModelNode update = Util.getWriteAttributeOperation(address, "heap-size", size);
            updates.add(update);
        }
        if (maxSize != null) {
            ModelNode update = Util.getWriteAttributeOperation(address, "max-heap-size", maxSize);
            updates.add(update);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parsePermgen(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String size = null;
        String maxSize = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    size = value;
                    continue block4;
                }
                case MAX_SIZE: {
                    maxSize = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (size != null) {
            ModelNode update = Util.getWriteAttributeOperation(address, "permgen-size", size);
            updates.add(update);
        }
        if (maxSize != null) {
            ModelNode update = Util.getWriteAttributeOperation(address, "max-permgen-size", maxSize);
            updates.add(update);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStack(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean sizeSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "stack-size", value);
                    updates.add(update);
                    sizeSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!sizeSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SIZE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAgentLib(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "agent-lib", value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAgentPath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "agent-path", value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJavaagent(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    ModelNode update = Util.getWriteAttributeOperation(address, "java-agent", value);
                    updates.add(update);
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJvmOptions(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        boolean optionSet = false;
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.OPTION) {
                        String option = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case VALUE: {
                                    option = attrValue;
                                    continue block7;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute(reader, i);
                                }
                            }
                        }
                        if (option == null) {
                            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
                        }
                        ModelNode update = new ModelNode();
                        update.get("address").set(address);
                        update.get("operation").set("add-jvm-option");
                        update.get("jvm-option").set(option);
                        updates.add(update);
                        optionSet = true;
                        ParseUtils.requireNoContent(reader);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!optionSet) {
            throw ParseUtils.missingRequiredElement(reader, Collections.singleton(Element.OPTION));
        }
    }

    protected void parseInterfaceCriteria(XMLExtendedStreamReader reader, ModelNode criteria) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return;
        }
        if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
            throw ParseUtils.unexpectedElement(reader);
        }
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ANY_ADDRESS: 
            case ANY_IPV4_ADDRESS: 
            case ANY_IPV6_ADDRESS: {
                criteria.set(element.getLocalName());
                ParseUtils.requireNoContent(reader);
                ParseUtils.requireNoContent(reader);
                return;
            }
        }
        do {
            element = Element.forName(reader.getLocalName());
            switch (element) {
                case ANY: {
                    this.parseCompoundInterfaceCriterion(reader, criteria.add().set("any", new ModelNode()).get("any"));
                    break;
                }
                case NOT: {
                    this.parseCompoundInterfaceCriterion(reader, criteria.add().set("not", new ModelNode()).get("not"));
                    break;
                }
                default: {
                    this.parseSimpleInterfaceCriterion(reader, criteria.add());
                }
            }
        } while (reader.nextTag() != 2);
    }

    protected void parseCompoundInterfaceCriterion(XMLExtendedStreamReader reader, ModelNode criterion) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.nextTag() != 2) {
            this.parseSimpleInterfaceCriterion(reader, criterion.add());
        }
    }

    protected void parseContentType(XMLExtendedStreamReader reader, ModelNode parent) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case SHA1: {
                    try {
                        content.get("hash").set(HashUtil.hexStringToByteArray(value));
                        continue block5;
                    }
                    catch (Exception e) {
                        throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " does not represent a properly hex-encoded SHA1 hash", reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseSimpleInterfaceCriterion(XMLExtendedStreamReader reader, ModelNode criteria) throws XMLStreamException {
        if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
            throw ParseUtils.unexpectedElement(reader);
        }
        Element element = Element.forName(reader.getLocalName());
        String localName = element.getLocalName();
        switch (element) {
            case INET_ADDRESS: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ModelNode valueNode = ParseUtils.parsePossibleExpression(value);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, valueNode);
                break;
            }
            case LOOPBACK_ADDRESS: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, value);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                ParseUtils.requireNoAttributes(reader);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName);
                break;
            }
            case NIC: {
                ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, value);
                break;
            }
            case NIC_MATCH: {
                ParseUtils.requireSingleAttribute(reader, Attribute.PATTERN.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                criteria.set(localName, value);
                break;
            }
            case SUBNET_MATCH: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                String[] split = value.split("/");
                try {
                    if (split.length != 2) {
                        throw new XMLStreamException("Invalid 'value' " + value + " -- must be of the form address/mask", reader.getLocation());
                    }
                    InetAddress addr = InetAddress.getByName(split[0]);
                    addr.getAddress();
                    Integer.parseInt(split[1]);
                    criteria.set(localName, value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException("Invalid mask " + split[1] + " (" + e.getLocalizedMessage() + ")", reader.getLocation(), e);
                }
                catch (UnknownHostException e) {
                    throw new XMLStreamException("Invalid address " + split[1] + " (" + e.getLocalizedMessage() + ")", reader.getLocation(), e);
                }
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    protected void parseInterfaces(XMLExtendedStreamReader reader, Set<String> names, ModelNode address, List<ModelNode> list, boolean checkSpecified) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw new XMLStreamException("Duplicate interface declaration", reader.getLocation());
            }
            ModelNode interfaceAdd = new ModelNode();
            interfaceAdd.get("address").set(address).add("interface", name);
            interfaceAdd.get("operation").set("add");
            ModelNode criteriaNode = interfaceAdd.get("criteria");
            this.parseInterfaceCriteria(reader, criteriaNode);
            if (checkSpecified && criteriaNode.getType() != ModelType.STRING && criteriaNode.getType() != ModelType.EXPRESSION && criteriaNode.asInt() == 0) {
                throw ParseUtils.unexpectedEndElement(reader);
            }
            list.add(interfaceAdd);
        }
    }

    protected void parseSocketBindingGroupRef(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = null;
        int offset = -1;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REF: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    name = value;
                    continue block6;
                }
                case PORT_OFFSET: {
                    try {
                        if (offset != -1) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        offset = Integer.parseInt(value);
                        if (offset >= 0) continue block6;
                        throw new XMLStreamException(offset + " is not a valid " + attribute.getLocalName() + " -- must be greater than zero", reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException(offset + " is not a valid " + attribute.getLocalName(), reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.REF));
        }
        ParseUtils.requireNoContent(reader);
        ModelNode update = Util.getWriteAttributeOperation(address, "socket-binding-group", name);
        updates.add(update);
        if (offset < 0) {
            offset = 0;
        }
        if (offset > 0) {
            update = Util.getWriteAttributeOperation(address, "socket-binding-port-offset", offset);
        }
        updates.add(update);
    }

    protected String parseSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PORT);
        String name = null;
        ModelNode binding = new ModelNode();
        binding.get("address");
        binding.get("operation").set("add");
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    binding.get("address").set(address).add("socket-binding", name);
                    continue block10;
                }
                case INTERFACE: {
                    if (!interfaces.contains(value)) {
                        throw new XMLStreamException("Unknown interface " + value + " " + attribute.getLocalName() + " must be declared in element " + Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    binding.get("interface").set(value);
                    continue block10;
                }
                case PORT: {
                    binding.get("port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 0, 65535, true));
                    continue block10;
                }
                case FIXED_PORT: {
                    binding.get("fixed-port").set(Boolean.parseBoolean(value));
                    continue block10;
                }
                case MULTICAST_ADDRESS: {
                    ModelNode mcastNode = ParseUtils.parsePossibleExpression(value);
                    if (mcastNode.getType() == ModelType.EXPRESSION) {
                        binding.get("multicast-address").set(mcastNode);
                        continue block10;
                    }
                    try {
                        InetAddress mcastAddr = InetAddress.getByName(value);
                        if (!mcastAddr.isMulticastAddress()) {
                            throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " is not a valid multicast address", reader.getLocation());
                        }
                        binding.get("multicast-address").set(value);
                        continue block10;
                    }
                    catch (UnknownHostException e) {
                        throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " is not a valid multicast address", reader.getLocation(), e);
                    }
                }
                case MULTICAST_PORT: {
                    binding.get("multicast-port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 1, 65535, true));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        ParseUtils.requireNoContent(reader);
        updates.add(binding);
        return name;
    }

    protected void parseDeployments(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean allowEnabled) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            String uniqueName = null;
            String runtimeName = null;
            String startInput = null;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement(reader, value);
                        }
                        uniqueName = value;
                        continue block11;
                    }
                    case RUNTIME_NAME: {
                        runtimeName = value;
                        continue block11;
                    }
                    case ENABLED: {
                        if (allowEnabled) {
                            startInput = value;
                            continue block11;
                        }
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (uniqueName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
            }
            if (runtimeName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.RUNTIME_NAME));
            }
            boolean enabled = startInput == null ? true : Boolean.parseBoolean(startInput);
            ModelNode deploymentAddress = address.clone().add("deployment", uniqueName);
            ModelNode deploymentAdd = Util.getEmptyOperation("add", deploymentAddress);
            block12: while (reader.hasNext() && reader.nextTag() != 2) {
                if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
                    throw ParseUtils.unexpectedElement(reader);
                }
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case CONTENT: {
                        this.parseContentType(reader, deploymentAdd);
                        continue block12;
                    }
                    case FS_ARCHIVE: {
                        this.parseFSBaseType(reader, deploymentAdd, true);
                        continue block12;
                    }
                    case FS_EXPLODED: {
                        this.parseFSBaseType(reader, deploymentAdd, false);
                        continue block12;
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
            deploymentAdd.get("runtime-name").set(runtimeName);
            if (allowEnabled) {
                deploymentAdd.get("enabled").set(enabled);
            }
            list.add(deploymentAdd);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeInterfaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        writer.writeStartElement(Element.INTERFACES.getLocalName());
        Set interfaces = modelNode.keys();
        for (String ifaceName : interfaces) {
            ModelNode iface = modelNode.get(ifaceName);
            writer.writeStartElement(Element.INTERFACE.getLocalName());
            CommonXml.writeAttribute(writer, Attribute.NAME, ifaceName);
            ModelNode criteria = iface.get("criteria");
            if (criteria.getType() == ModelType.STRING) {
                String value = criteria.asString();
                if (value.equals(Element.ANY_ADDRESS.getLocalName())) {
                    writer.writeEmptyElement(Element.ANY_ADDRESS.getLocalName());
                } else if (value.equals(Element.ANY_IPV4_ADDRESS.getLocalName())) {
                    writer.writeEmptyElement(Element.ANY_IPV4_ADDRESS.getLocalName());
                } else {
                    if (!value.equals(Element.ANY_IPV6_ADDRESS.getLocalName())) throw new RuntimeException("Unkown criteria type: " + value);
                    writer.writeEmptyElement(Element.ANY_IPV6_ADDRESS.getLocalName());
                }
            } else if (criteria.getType() == ModelType.LIST) {
                List values = criteria.asList();
                this.writeInterfaceCriteria(writer, values);
            } else if (criteria.getType() != ModelType.UNDEFINED) {
                throw new RuntimeException("Unkown type for criteria node " + criteria);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, List<ModelNode> criteria) throws XMLStreamException {
        for (ModelNode value : criteria) {
            if (value.getType() == ModelType.PROPERTY) {
                this.writePropertyInterfaceCriteria(writer, value);
                continue;
            }
            if (value.getType() == ModelType.LIST) {
                this.writeInterfaceCriteria(writer, value.asList());
                continue;
            }
            this.writeSimpleInterfaceCriteria(writer, value);
        }
    }

    private void writePropertyInterfaceCriteria(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        Property property = node.asProperty();
        Element element = Element.forName(property.getName());
        writer.writeStartElement(element.getLocalName());
        switch (element) {
            case ANY: {
                this.writeInterfaceCriteria(writer, property.getValue().asList());
                break;
            }
            case NOT: {
                this.writeInterfaceCriteria(writer, property.getValue().asList());
                break;
            }
            case INET_ADDRESS: {
                CommonXml.writeAttribute(writer, Attribute.VALUE, property.getValue().asString());
                break;
            }
            case LOOPBACK_ADDRESS: {
                CommonXml.writeAttribute(writer, Attribute.VALUE, property.getValue().asString());
                break;
            }
            case NIC: {
                CommonXml.writeAttribute(writer, Attribute.NAME, property.getValue().asString());
                break;
            }
            case NIC_MATCH: {
                CommonXml.writeAttribute(writer, Attribute.PATTERN, property.getValue().asString());
                break;
            }
            case SUBNET_MATCH: {
                CommonXml.writeAttribute(writer, Attribute.VALUE, property.getValue().asString());
                break;
            }
            default: {
                throw new RuntimeException("Unknown property in interface criteria list: " + property.getName());
            }
        }
        writer.writeEndElement();
    }

    private void writeSimpleInterfaceCriteria(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        Element element = Element.forName(node.asString());
        writer.writeEmptyElement(element.getLocalName());
    }

    protected void writeSocketBindingGroup(XMLExtendedStreamWriter writer, ModelNode bindingGroup, boolean fromServer) throws XMLStreamException {
        writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
        ModelNode attr = bindingGroup.get("name");
        CommonXml.writeAttribute(writer, Attribute.NAME, attr.asString());
        attr = bindingGroup.get("default-interface");
        CommonXml.writeAttribute(writer, Attribute.DEFAULT_INTERFACE, attr.asString());
        if (fromServer && bindingGroup.hasDefined("port-offset") && bindingGroup.get("port-offset").asInt() > 0) {
            attr = bindingGroup.get("port-offset");
            CommonXml.writeAttribute(writer, Attribute.PORT_OFFSET, attr.asString());
        }
        if (!fromServer && bindingGroup.hasDefined("includes")) {
            for (ModelNode include : bindingGroup.get("includes").asList()) {
                writer.writeStartElement(Element.INCLUDE.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.SOCKET_BINDING_GROUP, include.asString());
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("socket-binding")) {
            ModelNode bindings = bindingGroup.get("socket-binding");
            for (String bindingName : bindings.keys()) {
                ModelNode binding = bindings.get(bindingName);
                writer.writeStartElement(Element.SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, bindingName);
                attr = binding.get("port");
                CommonXml.writeAttribute(writer, Attribute.PORT, attr.asString());
                attr = binding.get("fixed-port");
                if (attr.isDefined() && attr.asBoolean()) {
                    CommonXml.writeAttribute(writer, Attribute.FIXED_PORT, attr.asString());
                }
                if ((attr = binding.get("interface")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.INTERFACE, attr.asString());
                }
                if ((attr = binding.get("multicast-address")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.MULTICAST_ADDRESS, attr.asString());
                }
                if ((attr = binding.get("multicast-port")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.MULTICAST_PORT, attr.asString());
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    protected void writeProperties(XMLExtendedStreamWriter writer, ModelNode modelNode, Element element, boolean standalone) throws XMLStreamException {
        List properties = modelNode.asPropertyList();
        if (properties.size() > 0) {
            writer.writeStartElement(element.getLocalName());
            for (Property prop : properties) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, prop.getName());
                ModelNode sysProp = prop.getValue();
                if (sysProp.hasDefined("value")) {
                    CommonXml.writeAttribute(writer, Attribute.VALUE, sysProp.get("value").asString());
                }
                if (!standalone && sysProp.hasDefined("boot-time") && !sysProp.get("boot-time").asBoolean()) {
                    CommonXml.writeAttribute(writer, Attribute.BOOT_TIME, "false");
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    protected void writeJVMElement(XMLExtendedStreamWriter writer, String jvmName, ModelNode jvmElement) throws XMLStreamException {
        writer.writeStartElement(Element.JVM.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), jvmName);
        if (jvmElement.hasDefined("type")) {
            writer.writeAttribute(Attribute.TYPE.getLocalName(), jvmElement.get("type").asString());
        }
        if (jvmElement.hasDefined("java-home")) {
            writer.writeAttribute(Attribute.JAVA_HOME.getLocalName(), jvmElement.get("java-home").asString());
        }
        if (jvmElement.hasDefined("debug-enabled")) {
            writer.writeAttribute(Attribute.DEBUG_ENABLED.getLocalName(), jvmElement.get("debug-enabled").asString());
        }
        if (jvmElement.hasDefined("debug-options")) {
            if (!jvmElement.hasDefined("debug-enabled")) {
                writer.writeAttribute(Attribute.DEBUG_ENABLED.getLocalName(), "false");
            }
            writer.writeAttribute(Attribute.DEBUG_OPTIONS.getLocalName(), jvmElement.get("debug-options").asString());
        }
        if (jvmElement.hasDefined("env-classpath-ignored")) {
            writer.writeAttribute(Attribute.ENV_CLASSPATH_IGNORED.getLocalName(), jvmElement.get("env-classpath-ignored").asString());
        }
        if (jvmElement.hasDefined("heap-size") || jvmElement.hasDefined("max-heap-size")) {
            writer.writeEmptyElement(Element.HEAP.getLocalName());
            if (jvmElement.hasDefined("heap-size")) {
                writer.writeAttribute(Attribute.SIZE.getLocalName(), jvmElement.get("heap-size").asString());
            }
            if (jvmElement.hasDefined("max-heap-size")) {
                writer.writeAttribute(Attribute.MAX_SIZE.getLocalName(), jvmElement.get("max-heap-size").asString());
            }
        }
        if (jvmElement.hasDefined("permgen-size") || jvmElement.hasDefined("max-permgen-size")) {
            writer.writeEmptyElement(Element.PERMGEN.getLocalName());
            if (jvmElement.hasDefined("permgen-size")) {
                writer.writeAttribute(Attribute.SIZE.getLocalName(), jvmElement.get("permgen-size").asString());
            }
            if (jvmElement.hasDefined("max-permgen-size")) {
                writer.writeAttribute(Attribute.MAX_SIZE.getLocalName(), jvmElement.get("max-permgen-size").asString());
            }
        }
        if (jvmElement.hasDefined("stack-size")) {
            writer.writeEmptyElement(Element.STACK.getLocalName());
            writer.writeAttribute(Attribute.SIZE.getLocalName(), jvmElement.get("stack-size").asString());
        }
        if (jvmElement.hasDefined("agent-lib")) {
            writer.writeEmptyElement(Element.AGENT_LIB.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("agent-lib").asString());
        }
        if (jvmElement.hasDefined("agent-path")) {
            writer.writeEmptyElement(Element.AGENT_PATH.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("agent-path").asString());
        }
        if (jvmElement.hasDefined("java-agent")) {
            writer.writeEmptyElement(Element.JAVA_AGENT.getLocalName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), jvmElement.get("java-agent").asString());
        }
        if (jvmElement.hasDefined("jvm-options")) {
            writer.writeStartElement(Element.JVM_OPTIONS.getLocalName());
            for (ModelNode option : jvmElement.get("jvm-options").asList()) {
                writer.writeEmptyElement(Element.OPTION.getLocalName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), option.asString());
            }
            writer.writeEndElement();
        }
        if (jvmElement.hasDefined("environment-variables")) {
            writer.writeStartElement(Element.ENVIRONMENT_VARIABLES.getLocalName());
            for (Property variable : jvmElement.get("environment-variables").asPropertyList()) {
                writer.writeEmptyElement(Element.VARIABLE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), variable.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), variable.getValue().asString());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void writeManagement(XMLExtendedStreamWriter writer, ModelNode management, boolean allowInterfaces) throws XMLStreamException {
        boolean hasInterface;
        boolean hasSecurityRealm = management.hasDefined("security-realm");
        boolean hasConnection = management.hasDefined("outbound-connection");
        boolean bl = hasInterface = allowInterfaces && management.hasDefined("management-interface");
        if (!(hasSecurityRealm || hasConnection || hasInterface)) {
            return;
        }
        writer.writeStartElement(Element.MANAGEMENT.getLocalName());
        if (hasSecurityRealm) {
            ModelNode securityRealms = management.get("security-realm");
            writer.writeStartElement(Element.SECURITY_REALMS.getLocalName());
            for (Property variable : securityRealms.asPropertyList()) {
                writer.writeStartElement(Element.SECURITY_REALM.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, variable.getName());
                ModelNode realm = variable.getValue();
                if (realm.hasDefined("server-identities")) {
                    writer.writeStartElement(Element.SERVER_IDENTITIES.getLocalName());
                    ModelNode serverIdentities = realm.get("server-identities");
                    if (serverIdentities.hasDefined("ssl")) {
                        writer.writeStartElement(Element.SSL.getLocalName());
                        ModelNode ssl = serverIdentities.get("ssl");
                        if (ssl.hasDefined("protocol")) {
                            writer.writeAttribute(Attribute.PROTOCOL.getLocalName(), ssl.get("protocol").asString());
                        }
                        if (ssl.hasDefined("keystore")) {
                            writer.writeStartElement(Element.KEYSTORE.getLocalName());
                            ModelNode keystore = ssl.get("keystore");
                            writer.writeAttribute(Attribute.PATH.getLocalName(), keystore.require("path").asString());
                            if (keystore.hasDefined("relative-to")) {
                                writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), keystore.require("relative-to").asString());
                            }
                            writer.writeAttribute(Attribute.PASSWORD.getLocalName(), keystore.require("password").asString());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (serverIdentities.hasDefined("secret")) {
                        ModelNode secret = serverIdentities.get("secret");
                        writer.writeStartElement(Element.SECRET.getLocalName());
                        writer.writeAttribute(Attribute.VALUE.getLocalName(), secret.require("value").asString());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (realm.hasDefined("authentication")) {
                    writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
                    ModelNode authentication = realm.require("authentication");
                    if (authentication.hasDefined("users")) {
                        ModelNode userDomain = authentication.get("users");
                        ModelNode users = userDomain.require("user");
                        writer.writeStartElement(Element.USERS.getLocalName());
                        for (Property userProps : users.asPropertyList()) {
                            String userName = userProps.getName();
                            ModelNode currentUser = userProps.getValue();
                            writer.writeStartElement(Element.USER.getLocalName());
                            writer.writeAttribute(Attribute.USERNAME.getLocalName(), userName);
                            if (currentUser.hasDefined("password")) {
                                writer.writeStartElement(Element.PASSWORD.getLocalName());
                                writer.writeCharacters(currentUser.get("password").asString());
                                writer.writeEndElement();
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    } else if (authentication.hasDefined("ldap")) {
                        ModelNode userLdap = authentication.get("ldap");
                        writer.writeStartElement(Element.LDAP.getLocalName());
                        writer.writeAttribute(Attribute.CONNECTION.getLocalName(), userLdap.require("connection").asString());
                        writer.writeAttribute(Attribute.BASE_DN.getLocalName(), userLdap.require("base-dn").asString());
                        writer.writeAttribute(Attribute.USERNAME_ATTRIBUTE.getLocalName(), userLdap.require("username-attribute").asString());
                        if (userLdap.has("recursive")) {
                            writer.writeAttribute(Attribute.RECURSIVE.getLocalName(), userLdap.require("recursive").asString());
                        }
                        if (userLdap.hasDefined("user-dn")) {
                            writer.writeAttribute(Attribute.USER_DN.getLocalName(), userLdap.require("user-dn").asString());
                        }
                        writer.writeEndElement();
                    } else if (authentication.hasDefined("properties")) {
                        ModelNode properties = authentication.require("properties");
                        writer.writeStartElement(Element.PROPERTIES.getLocalName());
                        writer.writeAttribute(Attribute.PATH.getLocalName(), properties.require("path").asString());
                        if (properties.hasDefined("relative-to")) {
                            writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), properties.require("relative-to").asString());
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (hasConnection) {
            writer.writeStartElement(Element.OUTBOUND_CONNECTIONS.getLocalName());
            ModelNode connections = management.get("outbound-connection");
            for (Property variable : connections.asPropertyList()) {
                ModelNode connection = variable.getValue();
                String type = connection.require("type").asString();
                if (!"ldap".equals(type)) continue;
                writer.writeStartElement(Element.LDAP.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), variable.getName());
                writer.writeAttribute(Attribute.URL.getLocalName(), connection.require("url").asString());
                writer.writeAttribute(Attribute.SEARCH_DN.getLocalName(), connection.require("search-dn").asString());
                writer.writeAttribute(Attribute.SEARCH_CREDENTIAL.getLocalName(), connection.require("search-credential").asString());
                if (connection.has("initial-context-factory")) {
                    writer.writeAttribute(Attribute.INITIAL_CONTEXT_FACTORY.getLocalName(), connection.require("initial-context-factory").asString());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (allowInterfaces && hasInterface) {
            writer.writeStartElement(Element.MANAGEMENT_INTERFACES.getLocalName());
            ModelNode managementInterfaces = management.get("management-interface");
            if (managementInterfaces.hasDefined("native-interface")) {
                this.writeManagementProtocol(Element.NATIVE_INTERFACE, writer, managementInterfaces.get("native-interface"));
            }
            if (managementInterfaces.hasDefined("http-interface")) {
                this.writeManagementProtocol(Element.HTTP_INTERFACE, writer, managementInterfaces.get("http-interface"));
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeManagementProtocol(Element type, XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        String iface = protocol.get("interface").asString();
        writer.writeStartElement(type.getLocalName());
        CommonXml.writeAttribute(writer, Attribute.INTERFACE, iface);
        if (protocol.has("port")) {
            CommonXml.writeAttribute(writer, Attribute.PORT, protocol.get("port").asString());
        }
        if (protocol.has("secure-port")) {
            CommonXml.writeAttribute(writer, Attribute.SECURE_PORT, protocol.get("secure-port").asString());
        }
        if (protocol.hasDefined("max-threads")) {
            CommonXml.writeAttribute(writer, Attribute.MAX_THREADS, protocol.get("max-threads").asString());
        }
        if (protocol.hasDefined("security-realm")) {
            CommonXml.writeAttribute(writer, Attribute.SECURITY_REALM, protocol.get("security-realm").asString());
        }
        writer.writeEndElement();
    }

    protected static void writeContentItem(XMLExtendedStreamWriter writer, ModelNode contentItem) throws XMLStreamException {
        if (contentItem.has("hash")) {
            CommonXml.writeElement(writer, Element.CONTENT);
            CommonXml.writeAttribute(writer, Attribute.SHA1, HashUtil.bytesToHexString(contentItem.require("hash").asBytes()));
            writer.writeEndElement();
        } else {
            if (contentItem.require("archive").asBoolean()) {
                CommonXml.writeElement(writer, Element.FS_ARCHIVE);
            } else {
                CommonXml.writeElement(writer, Element.FS_EXPLODED);
            }
            CommonXml.writeAttribute(writer, Attribute.PATH, contentItem.require("path").asString());
            if (contentItem.has("relative-to")) {
                CommonXml.writeAttribute(writer, Attribute.RELATIVE_TO, contentItem.require("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    static {
        HashSet<String> set = new HashSet<String>(10);
        set.add("jboss.home");
        set.add("jboss.home.dir");
        set.add("user.home");
        set.add("user.dir");
        set.add("java.home");
        set.add("jboss.server.base.dir");
        set.add("jboss.server.data.dir");
        set.add("jboss.server.log.dir");
        set.add("jboss.server.temp.dir");
        set.add("jboss.modules.dir");
        set.add("jboss.server.deploy.dir");
        set.add("jboss.domain.servers.dir");
        RESTRICTED_PATHS = Collections.unmodifiableSet(set);
    }
}

