/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.integrator.internal;

import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import org.hibernate.cfg.beanvalidation.BeanValidationIntegrator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class IntegratorServiceImpl
implements IntegratorService {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)IntegratorServiceImpl.class.getName());
    private final ServiceRegistryImplementor serviceRegistry;
    private LinkedHashSet<Integrator> integrators = new LinkedHashSet();

    public IntegratorServiceImpl(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.addIntegrator(new BeanValidationIntegrator());
    }

    @Override
    public void addIntegrator(Integrator integrator) {
        LOG.debugf("Adding Integrator [%s].", integrator.getClass().getName());
        this.integrators.add(integrator);
    }

    @Override
    public Iterable<Integrator> getIntegrators() {
        LinkedHashSet<Integrator> integrators = new LinkedHashSet<Integrator>();
        integrators.addAll(this.integrators);
        for (Integrator integrator : ServiceLoader.load(Integrator.class)) {
            LOG.debugf("Adding Integrator [%s].", integrator.getClass().getName());
            integrators.add(integrator);
        }
        return integrators;
    }
}

