/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.attribute.ColumnSourceImpl;
import org.hibernate.metamodel.source.annotations.attribute.ExplicitHibernateTypeSourceImpl;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;

public class SingularAttributeSourceImpl
implements SingularAttributeSource {
    private final BasicAttribute attribute;
    private final AttributeOverride attributeOverride;

    public SingularAttributeSourceImpl(BasicAttribute attribute) {
        this(attribute, null);
    }

    public SingularAttributeSourceImpl(BasicAttribute attribute, AttributeOverride attributeOverride) {
        this.attribute = attribute;
        this.attributeOverride = attributeOverride;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return new ExplicitHibernateTypeSourceImpl(this.attribute.getHibernateTypeResolver());
    }

    @Override
    public String getPropertyAccessorName() {
        return this.attribute.getAccessType();
    }

    @Override
    public boolean isInsertable() {
        return this.attribute.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        return this.attribute.isUpdatable();
    }

    @Override
    public PropertyGeneration getGeneration() {
        return this.attribute.getPropertyGeneration();
    }

    @Override
    public boolean isLazy() {
        return this.attribute.isLazy();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.attribute.isOptimisticLockable();
    }

    @Override
    public String getName() {
        return this.attribute.getName();
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        ArrayList<RelationalValueSource> valueSources = new ArrayList<RelationalValueSource>();
        valueSources.add(new ColumnSourceImpl(this.attribute, this.attributeOverride));
        return valueSources;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.BASIC;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Collections.emptySet();
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return true;
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return true;
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return true;
    }
}

