/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.Serializable;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.jboss.as.logging.PatternFormatterSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.formatters.PatternFormatter;

public abstract class AbstractFormatterSpec
implements Serializable {
    private static final long serialVersionUID = -2383088369142242658L;

    protected abstract void apply(Handler var1);

    public static final class Factory {
        private static final AbstractFormatterSpec DEFAULT_FORMATTER_SPEC = new AbstractFormatterSpec(){
            private static final long serialVersionUID = -7900863870629839192L;
            public static final String PATTERN = "%d{HH:mm:ss,SSS} %-5p [%c] (%t) %s%E%n";

            @Override
            protected void apply(Handler handler) {
                handler.setFormatter((Formatter)new PatternFormatter(PATTERN));
            }
        };

        private Factory() {
        }

        public static AbstractFormatterSpec create(ModelNode node) {
            if (node.hasDefined("formatter")) {
                return new PatternFormatterSpec(node.get("formatter").asString());
            }
            return DEFAULT_FORMATTER_SPEC;
        }
    }
}

