/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.webservices.dmr.Element;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.wsf.spi.util.StAXUtils;

final class WebservicesSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final WebservicesSubsystemParser INSTANCE = new WebservicesSubsystemParser();

    WebservicesSubsystemParser() {
    }

    static WebservicesSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        writer.writeNamespace("javaee", Namespace.JAVAEE.getUriString());
        writer.writeNamespace("jaxwsconfig", Namespace.JAXWSCONFIG.getUriString());
        ModelNode node = context.getModelNode();
        this.writeElement(writer, Element.WSDL_HOST, node.require("wsdl-host"));
        this.writeElement(writer, Element.MODIFY_WSDL_ADDRESS, node.require("modify-wsdl-address"));
        if (this.has(node, "wsdl-secure-port")) {
            this.writeElement(writer, Element.WSDL_SECURE_PORT, node.require("wsdl-secure-port"));
        }
        if (this.has(node, "wsdl-port")) {
            this.writeElement(writer, Element.WSDL_PORT, node.require("wsdl-port"));
        }
        if (this.has(node, "endpoint-config")) {
            for (String name : node.get("endpoint-config").keys()) {
                this.writeEndpointConfig(writer, name, node.get(new String[]{"endpoint-config", name}));
            }
        }
        writer.writeEndElement();
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private void writeEndpointConfig(XMLExtendedStreamWriter writer, String name, ModelNode value) throws XMLStreamException {
        ModelNode handlerChains;
        writer.writeStartElement("endpoint-config");
        writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "config-name");
        writer.writeCharacters(name);
        writer.writeEndElement();
        if (value.hasDefined("pre-handler-chains")) {
            writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "pre-handler-chains");
            handlerChains = value.get("pre-handler-chains");
            this.writeHandlerChains(writer, handlerChains);
            writer.writeEndElement();
        }
        if (value.hasDefined("post-handler-chains")) {
            writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "post-handler-chains");
            handlerChains = value.get("post-handler-chains");
            this.writeHandlerChains(writer, handlerChains);
            writer.writeEndElement();
        }
        if (value.hasDefined("property")) {
            for (String key : value.get("property").keys()) {
                writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "property");
                writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "property-name");
                writer.writeCharacters(key);
                writer.writeEndElement();
                writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "property-value");
                writer.writeCharacters(value.get("property").get(key).asString());
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        if (value.hasDefined("feature")) {
            for (String key : value.get("feature").keys()) {
                writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "feature");
                writer.writeStartElement(Namespace.JAXWSCONFIG.getUriString(), "feature-name");
                writer.writeCharacters(key);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeHandlerChains(XMLExtendedStreamWriter writer, ModelNode handlerChains) throws XMLStreamException {
        if (handlerChains.getType() == ModelType.LIST) {
            for (ModelNode handlerChain : handlerChains.asList()) {
                writer.writeStartElement(Namespace.JAVAEE.getUriString(), "handler-chain");
                if (handlerChain.hasDefined("protocol-bindings")) {
                    writer.writeStartElement(Namespace.JAVAEE.getUriString(), "protocol-bindings");
                    writer.writeCharacters(handlerChain.get("protocol-bindings").asString());
                    writer.writeEndElement();
                }
                if (handlerChain.hasDefined("service-name-pattern")) {
                    writer.writeStartElement(Namespace.JAVAEE.getUriString(), "service-name-pattern");
                    writer.writeCharacters(handlerChain.get("service-name-pattern").asString());
                    writer.writeEndElement();
                }
                if (handlerChain.hasDefined("port-name-pattern")) {
                    writer.writeStartElement(Namespace.JAVAEE.getUriString(), "port-name-pattern");
                    writer.writeCharacters(handlerChain.get("port-name-pattern").asString());
                    writer.writeEndElement();
                }
                if (handlerChain.hasDefined("handler")) {
                    for (String key : handlerChain.get("handler").keys()) {
                        writer.writeStartElement(Namespace.JAVAEE.getUriString(), "handler");
                        writer.writeStartElement(Namespace.JAVAEE.getUriString(), "handler-name");
                        writer.writeCharacters(key);
                        writer.writeEndElement();
                        writer.writeStartElement(Namespace.JAVAEE.getUriString(), "handler-class");
                        writer.writeCharacters(handlerChain.get("handler").get(key).asString());
                        writer.writeEndElement();
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeElement(XMLExtendedStreamWriter writer, Element element, ModelNode value) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        writer.writeCharacters(value.asString());
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", "webservices");
        ArrayList<ModelNode> endpointConfigs = new ArrayList<ModelNode>();
        EnumSet<Element> required = EnumSet.of(Element.MODIFY_WSDL_ADDRESS, Element.WSDL_HOST);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEBSERVICES_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    required.remove((Object)element);
                    if (element != Element.ENDPOINT_CONFIG && !encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case WSDL_HOST: {
                            subsystem.get("wsdl-host").set(this.parseElementNoAttributes(reader));
                            continue block10;
                        }
                        case MODIFY_WSDL_ADDRESS: {
                            boolean b = Boolean.parseBoolean(this.parseElementNoAttributes(reader));
                            subsystem.get("modify-wsdl-address").set(b);
                            continue block10;
                        }
                        case WSDL_PORT: {
                            int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-port").set(port);
                            continue block10;
                        }
                        case WSDL_SECURE_PORT: {
                            int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-secure-port").set(port);
                            continue block10;
                        }
                        case ENDPOINT_CONFIG: {
                            this.readEndpointConfig(reader, subsystem.get("address"), endpointConfigs);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
        list.add(subsystem);
        list.addAll(endpointConfigs);
    }

    private String parseElementNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        return reader.getElementText().trim();
    }

    private void readEndpointConfig(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationList) throws XMLStreamException {
        String configName = null;
        ModelNode preHandlers = null;
        ModelNode postHandlers = null;
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block7: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.FEATURE && element != Element.PROPERTY && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CONFIG_NAME: {
                    configName = this.parseElementNoAttributes(reader);
                    node.get("address").set(address).add("endpoint-config", configName);
                    continue block7;
                }
                case PRE_HANDLER_CHAINS: {
                    preHandlers = this.parseHandlerChains(reader);
                    node.get("pre-handler-chains").set(preHandlers);
                    continue block7;
                }
                case POST_HANDLER_CHAINS: {
                    postHandlers = this.parseHandlerChains(reader);
                    node.get("post-handler-chains").set(postHandlers);
                    continue block7;
                }
                case PROPERTY: {
                    this.parseProperty(reader, node);
                    continue block7;
                }
                case FEATURE: {
                    this.parseFeature(reader, node);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operationList.add(node);
    }

    private void parseProperty(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String propertyName = null;
        String propertyValue = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTY_NAME: {
                    propertyName = this.parseElementNoAttributes(reader);
                    continue block4;
                }
                case PROPERTY_VALUE: {
                    propertyValue = this.parseElementNoAttributes(reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        node.get("property").get(propertyName).set(propertyValue);
    }

    private void parseFeature(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String featureName = null;
        String featureData = "";
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            block0 : switch (element) {
                case FEATURE_NAME: {
                    featureName = this.parseElementNoAttributes(reader);
                    break;
                }
                case FEATURE_DATA: {
                    while (reader.hasNext()) {
                        if (reader.next() != 2 || !StAXUtils.match((XMLStreamReader)reader, (String)Namespace.JAXWSCONFIG.getUriString(), (String)"feature-data")) continue;
                        break block0;
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        node.get("feature").get(featureName).set(featureData);
    }

    private ModelNode parseHandlerChains(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode chainsNode = new ModelNode();
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block3: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.HANDLER_CHAIN && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HANDLER_CHAIN: {
                    ModelNode chainNode = new ModelNode();
                    this.parseHandlerChain(reader, chainNode);
                    chainsNode.add(chainNode);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return chainsNode;
    }

    private void parseHandlerChain(XMLExtendedStreamReader reader, ModelNode chainNode) throws XMLStreamException {
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block6: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.HANDLER && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROTOCOL_BINDING: {
                    String binding = this.parseElementNoAttributes(reader);
                    chainNode.get("protocol-bindings").set(binding);
                    continue block6;
                }
                case SERVICE_NAME_PATTERN: {
                    String serviceNamePattern = this.parseElementNoAttributes(reader);
                    chainNode.get("service-name-pattern").set(serviceNamePattern);
                    continue block6;
                }
                case PORT_NAME_PATTERN: {
                    String portNamePattern = this.parseElementNoAttributes(reader);
                    chainNode.get("port-name-pattern").set(portNamePattern);
                    continue block6;
                }
                case HANDLER: {
                    this.parseHandler(reader, chainNode);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHandler(XMLExtendedStreamReader reader, ModelNode chainNode) throws XMLStreamException {
        String handlerName = null;
        String handlerClass = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HANDLER_NAME: {
                    handlerName = this.parseElementNoAttributes(reader);
                    continue block4;
                }
                case HANDLER_CLASS: {
                    handlerClass = this.parseElementNoAttributes(reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        chainNode.get("handler").get(handlerName).set(handlerClass);
    }
}

