/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation.header;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.operation.header.ConcurrentSignState;
import org.jboss.as.cli.parsing.operation.header.ServerGroupSeparatorState;
import org.jboss.as.cli.parsing.operation.header.ServerGroupState;

public class ServerGroupListState
extends DefaultParsingState {
    public static final ServerGroupListState INSTANCE = new ServerGroupListState();
    public static final String ID = "SG_LIST";

    ServerGroupListState() {
        this(ServerGroupState.INSTANCE, ServerGroupSeparatorState.INSTANCE, ConcurrentSignState.INSTANCE);
    }

    ServerGroupListState(ServerGroupState sg, ServerGroupSeparatorState gs, ConcurrentSignState cs) {
        super(ID);
        this.setIgnoreWhitespaces(true);
        this.setDefaultHandler(new EnterStateCharacterHandler(sg));
        this.putHandler('^', new EnterStateCharacterHandler(cs));
        this.putHandler(',', new EnterStateCharacterHandler(gs));
        this.putHandler('}', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.putHandler(';', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    return;
                }
                if (Character.isWhitespace(ctx.getCharacter())) {
                    ctx.leaveState();
                } else {
                    ServerGroupListState.this.getHandler(ctx.getCharacter()).handle(ctx);
                }
            }
        });
    }
}

