/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.Services;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.operations.SecurityActions;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.xnio.OptionMap;

public class NativeManagementAddHandler
extends AbstractAddStepHandler {
    public static final NativeManagementAddHandler INSTANCE = new NativeManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition definition : NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            NativeManagementAddHandler.validateAndSet(definition, operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName endpointName = ManagementRemotingServices.MANAGEMENT_ENDPOINT;
        String hostName = SecurityActions.getSystemProperty("jboss.node.name");
        ManagementRemotingServices.installRemotingEndpoint((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (String)hostName, (EndpointService.EndpointType)EndpointService.EndpointType.MANAGEMENT, (ServiceVerificationHandler)verificationHandler, newControllers);
        NativeManagementAddHandler.installNativeManagementConnector(context, model, endpointName, serviceTarget, verificationHandler, newControllers);
        ManagementRemotingServices.installManagementChannelServices((ServiceTarget)serviceTarget, (ServiceName)endpointName, (AbstractModelControllerOperationHandlerFactoryService)new ModelControllerClientOperationHandlerFactoryService(), (ServiceName)Services.JBOSS_SERVER_CONTROLLER, (String)"management", (ServiceVerificationHandler)verificationHandler, newControllers);
    }

    private static void validateAndSet(AttributeDefinition definition, ModelNode operation, ModelNode subModel) throws OperationFailedException {
        String attributeName = definition.getName();
        boolean has = operation.has(attributeName);
        if (!has && definition.isRequired(operation)) {
            throw new OperationFailedException(new ModelNode().set(String.format("%s is required", attributeName)));
        }
        if (has) {
            if (!definition.isAllowed(operation)) {
                throw new OperationFailedException(new ModelNode().set(String.format("%s is not allowed when [%s] are present", attributeName, definition.getAlternatives())));
            }
            definition.validateAndSet(operation, subModel);
        } else {
            subModel.get(definition.getName());
        }
    }

    private static ModelNode validateResolvedModel(AttributeDefinition definition, OperationContext context, ModelNode subModel) throws OperationFailedException {
        ModelNode result;
        String attributeName = definition.getName();
        boolean has = subModel.has(attributeName);
        if (!has && definition.isRequired(subModel)) {
            throw new OperationFailedException(new ModelNode().set(String.format("%s is required", attributeName)));
        }
        if (has) {
            if (!definition.isAllowed(subModel)) {
                if (subModel.hasDefined(attributeName)) {
                    throw new OperationFailedException(new ModelNode().set(String.format("%s is not allowed when [%s] are present", attributeName, definition.getAlternatives())));
                }
                result = new ModelNode();
            } else {
                result = definition.resolveModelAttribute(context, subModel);
            }
        } else {
            result = new ModelNode();
        }
        return result;
    }

    static void installNativeManagementConnector(OperationContext context, ModelNode model, ServiceName endpointName, ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName socketBindingServiceName = null;
        ServiceName interfaceSvcName = null;
        int port = 0;
        ModelNode socketBindingNode = NativeManagementAddHandler.validateResolvedModel((AttributeDefinition)NativeManagementResourceDefinition.SOCKET_BINDING, context, model);
        if (socketBindingNode.isDefined()) {
            String bindingName = NativeManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
            socketBindingServiceName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName});
        } else {
            String interfaceName = NativeManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString();
            interfaceSvcName = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName});
            port = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, model).asInt();
        }
        ServiceName realmSvcName = null;
        ModelNode realmNode = NativeManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        if (realmNode.isDefined()) {
            realmSvcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmNode.asString()});
        } else {
            Logger.getLogger((String)"org.jboss.as").warn((Object)"No security realm defined for native management service, all access will be unrestricted.");
        }
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.home.dir"});
        RemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"management", (ServiceName)realmSvcName, null, (ServiceName)tmpDirPath, (ServiceVerificationHandler)verificationHandler, newControllers);
        if (socketBindingServiceName == null) {
            ManagementRemotingServices.installConnectorServicesForNetworkInterfaceBinding((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)"management", (ServiceName)interfaceSvcName, (int)port, (OptionMap)OptionMap.EMPTY, (ServiceVerificationHandler)verificationHandler, newControllers);
        } else {
            ManagementRemotingServices.installConnectorServicesForSocketBinding((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)"management", (ServiceName)socketBindingServiceName, (OptionMap)OptionMap.EMPTY, (ServiceVerificationHandler)verificationHandler, newControllers);
        }
    }
}

