/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.ccm;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.ccm.KeyConnectionAssociation;
import org.jboss.jca.core.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.core.spi.transaction.TxUtils;
import org.jboss.jca.core.spi.transaction.usertx.UserTransactionListener;
import org.jboss.jca.core.spi.transaction.usertx.UserTransactionRegistry;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class CachedConnectionManagerImpl
implements CachedConnectionManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)CachedConnectionManager.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private boolean debug = false;
    private boolean error = false;
    private TransactionManager transactionManager;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private UserTransactionRegistry userTransactionRegistry;
    private final ThreadLocal<LinkedList<Object>> currentObjects = new ThreadLocal();
    private final ConcurrentMap<KeyConnectionAssociation, ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>>> objectToConnectionManagerMap = new ConcurrentHashMap<KeyConnectionAssociation, ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>>>();
    private final Map<Object, Throwable> connectionStackTraces = new WeakHashMap<Object, Throwable>();

    public CachedConnectionManagerImpl(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, UserTransactionRegistry userTransactionRegistry) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.userTransactionRegistry = userTransactionRegistry;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    public void setDebug(boolean v) {
        this.debug = v;
    }

    public void setError(boolean v) {
        this.error = v;
    }

    public void start() {
        if (this.userTransactionRegistry != null) {
            this.userTransactionRegistry.addListener((UserTransactionListener)this);
        }
    }

    public void stop() {
        if (this.userTransactionRegistry != null) {
            this.userTransactionRegistry.removeListener((UserTransactionListener)this);
        }
    }

    public void userTransactionStarted() throws SystemException {
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.tracef("user tx started, key: %s", key);
        }
        if (key != null) {
            ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
            for (Map.Entry entry : cmToConnectionsMap.entrySet()) {
                ConnectionCacheListener cm = (ConnectionCacheListener)entry.getKey();
                CopyOnWriteArrayList conns = (CopyOnWriteArrayList)entry.getValue();
                cm.transactionStarted(conns);
            }
        }
    }

    private KeyConnectionAssociation peekMetaAwareObject() {
        LinkedList<Object> stack = this.currentObjects.get();
        if (stack != null && !stack.isEmpty()) {
            return (KeyConnectionAssociation)stack.getLast();
        }
        return null;
    }

    public void popMetaAwareObject(Set unsharableResources) throws ResourceException {
        LinkedList<Object> stack = this.currentObjects.get();
        KeyConnectionAssociation oldKey = (KeyConnectionAssociation)stack.removeLast();
        if (trace) {
            log.tracef("popped object: %s", oldKey);
        }
        if (this.debug && this.closeAll(oldKey.getCMToConnectionsMap()) && this.error) {
            throw new ResourceException(bundle.someConnectionsWereNotClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnection(org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener cm, ConnectionListener cl, Object connection, ConnectionRequestInfo cri) {
        if (this.debug) {
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.put(connection, new Throwable("STACKTRACE"));
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.tracef("registering connection from connection manager: %s, connection : %s, key: %s", cm, connection, key);
        }
        if (key != null) {
            ConnectionRecord cr = new ConnectionRecord(cl, connection, cri);
            ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
            CopyOnWriteArrayList<ConnectionRecord> conns = (CopyOnWriteArrayList<ConnectionRecord>)cmToConnectionsMap.get(cm);
            if (conns == null) {
                conns = new CopyOnWriteArrayList<ConnectionRecord>();
                cmToConnectionsMap.put((ConnectionCacheListener)cm, conns);
            }
            conns.add(cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnection(org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener cm, Object connection) {
        if (this.debug) {
            CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(false);
            if (cas != null) {
                cas.remove(connection);
            }
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.remove(connection);
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.tracef("unregistering connection from connection manager: %s, connection: %s, key: %s", cm, connection, key);
        }
        if (key == null) {
            return;
        }
        ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
        CopyOnWriteArrayList conns = (CopyOnWriteArrayList)cmToConnectionsMap.get(cm);
        if (conns == null) {
            return;
        }
        for (ConnectionRecord connectionRecord : conns) {
            if (connectionRecord.getConnection() != connection) continue;
            conns.remove(connectionRecord);
            return;
        }
        throw new IllegalStateException("Trying to return an unknown connection2! " + connection);
    }

    public void pushMetaAwareObject(Object rawKey, Set unsharableResources) throws ResourceException {
        LinkedList<Object> stack = this.currentObjects.get();
        if (stack == null) {
            if (trace) {
                log.tracef("new stack for key: %s", rawKey);
            }
            stack = new LinkedList();
            this.currentObjects.set(stack);
        } else if (trace) {
            log.tracef("old stack for key: %s", rawKey);
        }
        KeyConnectionAssociation key = new KeyConnectionAssociation(rawKey);
        stack.addLast(key);
    }

    private void reconnect(KeyConnectionAssociation key, Set unsharableResources) throws ResourceException {
        ConcurrentMap cmToConnectionsMap = (ConcurrentMap)this.objectToConnectionManagerMap.get(key);
        if (cmToConnectionsMap == null) {
            return;
        }
        key.setCMToConnectionsMap(cmToConnectionsMap);
        for (Map.Entry entry : cmToConnectionsMap.entrySet()) {
            ConnectionCacheListener cm = (ConnectionCacheListener)entry.getKey();
            CopyOnWriteArrayList conns = (CopyOnWriteArrayList)entry.getValue();
            cm.reconnect(conns, unsharableResources);
        }
    }

    private void disconnect(KeyConnectionAssociation key, Set unsharableResources) throws ResourceException {
        ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
        if (!cmToConnectionsMap.isEmpty()) {
            this.objectToConnectionManagerMap.put(key, cmToConnectionsMap);
            for (Map.Entry entry : cmToConnectionsMap.entrySet()) {
                ConnectionCacheListener cm = (ConnectionCacheListener)entry.getKey();
                CopyOnWriteArrayList conns = (CopyOnWriteArrayList)entry.getValue();
                cm.disconnect(conns, unsharableResources);
            }
        }
    }

    public void unregisterConnectionCacheListener(ConnectionCacheListener cm) {
        if (trace) {
            log.tracef("unregisterConnectionCacheListener: %s", cm);
        }
        for (ConcurrentMap cmToConnectionsMap : this.objectToConnectionManagerMap.values()) {
            if (cmToConnectionsMap == null) continue;
            cmToConnectionsMap.remove(cm);
        }
    }

    private boolean closeAll(ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap) {
        boolean unclosed = false;
        Collection connections = cmToConnectionsMap.values();
        if (connections.size() != 0) {
            for (CopyOnWriteArrayList conns : connections) {
                Iterator j = conns.iterator();
                while (j.hasNext()) {
                    Object c = ((ConnectionRecord)j.next()).getConnection();
                    CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(true);
                    if (cas == null) {
                        unclosed = true;
                        this.closeConnection(c);
                        continue;
                    }
                    cas.add(c);
                }
            }
        }
        return unclosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseConnectionSynchronization getCloseConnectionSynchronization(boolean createIfNotFound) {
        block7: {
            CloseConnectionSynchronization closeConnectionSynchronization;
            Transaction tx = null;
            if (this.transactionManager != null) {
                tx = this.transactionManager.getTransaction();
            }
            if (tx == null) break block7;
            TransactionSynchronizer.lock(tx);
            try {
                CloseConnectionSynchronization cas = (CloseConnectionSynchronization)TransactionSynchronizer.getCCMSynchronization(tx);
                if (cas == null && createIfNotFound && TxUtils.isActive((Transaction)tx)) {
                    cas = new CloseConnectionSynchronization();
                    TransactionSynchronizer.registerCCMSynchronization(tx, cas, this.transactionSynchronizationRegistry);
                }
                closeConnectionSynchronization = cas;
            }
            catch (Throwable throwable) {
                try {
                    TransactionSynchronizer.unlock(tx);
                    throw throwable;
                }
                catch (Throwable t) {
                    log.debug("Unable to synchronize with transaction", t);
                }
            }
            TransactionSynchronizer.unlock(tx);
            return closeConnectionSynchronization;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Object connectionHandle) {
        try {
            Throwable exception;
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                exception = this.connectionStackTraces.remove(connectionHandle);
            }
            Method m = connectionHandle.getClass().getMethod("close", new Class[0]);
            try {
                if (exception != null) {
                    log.closingConnection(connectionHandle, exception);
                } else {
                    log.closingConnection(connectionHandle);
                }
                m.invoke(connectionHandle, new Object[0]);
            }
            catch (Throwable t) {
                log.closingConnectionThrowable(t);
            }
        }
        catch (NoSuchMethodException nsme) {
            log.closingConnectionNoClose(connectionHandle.getClass().getName());
        }
    }

    final ThreadLocal<LinkedList<Object>> getCurrentObjects() {
        return this.currentObjects;
    }

    private class CloseConnectionSynchronization
    implements Synchronization {
        CopyOnWriteArraySet<Object> connections = new CopyOnWriteArraySet();
        AtomicBoolean closing = new AtomicBoolean(false);

        public void add(Object c) {
            if (!this.closing.get()) {
                this.connections.add(c);
            }
        }

        public void remove(Object c) {
            if (!this.closing.get()) {
                this.connections.remove(c);
            }
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.closing.set(true);
            Iterator<Object> i = this.connections.iterator();
            while (i.hasNext()) {
                CachedConnectionManagerImpl.this.closeConnection(i.next());
            }
            this.connections.clear();
        }
    }
}

