/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.HashMap;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ear.spec.Ear6xMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.msc.service.ServiceName;

public class InitalizeInOrderProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        boolean inOrder;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent == null) {
            return;
        }
        EarMetaData earConfig = (EarMetaData)parent.getAttachment(Attachments.EAR_METADATA);
        if (earConfig != null && earConfig instanceof Ear6xMetaData && (inOrder = ((Ear6xMetaData)earConfig).getInitializeInOrder()) && earConfig.getModules().size() > 1) {
            HashMap<String, DeploymentUnit> deploymentUnitMap = new HashMap<String, DeploymentUnit>();
            for (DeploymentUnit subDeployment : (AttachmentList)parent.getAttachment(org.jboss.as.server.deployment.Attachments.SUB_DEPLOYMENTS)) {
                ResourceRoot deploymentRoot = (ResourceRoot)subDeployment.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
                ModuleMetaData moduleMetaData = (ModuleMetaData)deploymentRoot.getAttachment(Attachments.MODULE_META_DATA);
                if (moduleMetaData == null) continue;
                deploymentUnitMap.put(moduleMetaData.getFileName(), subDeployment);
            }
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
            ModuleMetaData thisModulesMetadata = (ModuleMetaData)deploymentRoot.getAttachment(Attachments.MODULE_META_DATA);
            if (thisModulesMetadata != null && thisModulesMetadata.getType() != ModuleMetaData.ModuleType.Client) {
                ModuleMetaData previous = null;
                boolean found = false;
                for (ModuleMetaData module : earConfig.getModules()) {
                    if (module.getType() == ModuleMetaData.ModuleType.Client) continue;
                    if (module.getFileName().equals(thisModulesMetadata.getFileName())) {
                        found = true;
                        break;
                    }
                    previous = module;
                }
                if (previous != null && found) {
                    ServiceName serviceName = Services.deploymentUnitName((String)parent.getName(), (String)previous.getFileName());
                    phaseContext.addToAttachmentList(org.jboss.as.server.deployment.Attachments.NEXT_PHASE_DEPS, (Object)serviceName.append(new String[]{Phase.INSTALL.name()}));
                    DeploymentUnit prevDeployment = (DeploymentUnit)deploymentUnitMap.get(previous.getFileName());
                    EEModuleDescription eeModuleDescription = (EEModuleDescription)prevDeployment.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
                    if (eeModuleDescription != null) {
                        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
                            phaseContext.addToAttachmentList(org.jboss.as.server.deployment.Attachments.NEXT_PHASE_DEPS, (Object)component.getStartServiceName());
                        }
                    }
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

