/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.registry.DriverService;
import org.jboss.as.connector.registry.InstalledDriver;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JdbcDriverAdd
extends AbstractAddStepHandler {
    static final JdbcDriverAdd INSTANCE = new JdbcDriverAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        String driverName = operation.require(Constants.DRIVER_NAME.getName()).asString();
        String moduleName = operation.require(Constants.DRIVER_MODULE_NAME.getName()).asString();
        Integer majorVersion = operation.hasDefined(Constants.DRIVER_MAJOR_VERSION.getName()) ? Integer.valueOf(operation.get(Constants.DRIVER_MAJOR_VERSION.getName()).asInt()) : null;
        Integer minorVersion = operation.hasDefined(Constants.DRIVER_MINOR_VERSION.getName()) ? Integer.valueOf(operation.get(Constants.DRIVER_MINOR_VERSION.getName()).asInt()) : null;
        String driverClassName = operation.hasDefined(Constants.DRIVER_CLASS_NAME.getName()) ? operation.get(Constants.DRIVER_CLASS_NAME.getName()).asString() : null;
        String dataSourceClassName = operation.hasDefined(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()) ? operation.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).asString() : null;
        String xaDataSourceClassName = operation.hasDefined(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()) ? operation.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).asString() : null;
        model.get(Constants.DRIVER_NAME.getName()).set(driverName);
        model.get(Constants.DRIVER_MODULE_NAME.getName()).set(moduleName);
        if (majorVersion != null) {
            model.get(Constants.DRIVER_MAJOR_VERSION.getName()).set(majorVersion.intValue());
        }
        if (minorVersion != null) {
            model.get(Constants.DRIVER_MINOR_VERSION.getName()).set(minorVersion.intValue());
        }
        if (driverClassName != null) {
            model.get(Constants.DRIVER_CLASS_NAME.getName()).set(driverClassName);
        }
        if (dataSourceClassName != null) {
            model.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).set(dataSourceClassName);
        }
        if (xaDataSourceClassName != null) {
            model.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).set(xaDataSourceClassName);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        block6: {
            Module module;
            ModuleIdentifier moduleId;
            ServiceTarget target;
            String xaDataSourceClassName;
            String dataSourceClassName;
            String driverClassName;
            Integer minorVersion;
            Integer majorVersion;
            String driverName;
            block5: {
                driverName = operation.require(Constants.DRIVER_NAME.getName()).asString();
                String moduleName = operation.require(Constants.DRIVER_MODULE_NAME.getName()).asString();
                majorVersion = operation.hasDefined(Constants.DRIVER_MAJOR_VERSION.getName()) ? Integer.valueOf(operation.get(Constants.DRIVER_MAJOR_VERSION.getName()).asInt()) : null;
                minorVersion = operation.hasDefined(Constants.DRIVER_MINOR_VERSION.getName()) ? Integer.valueOf(operation.get(Constants.DRIVER_MINOR_VERSION.getName()).asInt()) : null;
                driverClassName = operation.hasDefined(Constants.DRIVER_CLASS_NAME.getName()) ? operation.get(Constants.DRIVER_CLASS_NAME.getName()).asString() : null;
                dataSourceClassName = operation.hasDefined(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()) ? operation.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).asString() : null;
                xaDataSourceClassName = operation.hasDefined(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()) ? operation.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).asString() : null;
                target = context.getServiceTarget();
                try {
                    moduleId = ModuleIdentifier.create((String)moduleName);
                    module = Module.getCallerModuleLoader().loadModule(moduleId);
                }
                catch (ModuleLoadException e) {
                    context.getFailureDescription().set(ConnectorMessages.MESSAGES.failedToLoadModuleDriver(moduleName));
                    return;
                }
                if (driverClassName != null) break block5;
                ServiceLoader serviceLoader = module.loadService(Driver.class);
                if (serviceLoader == null) break block6;
                for (Driver driver : serviceLoader) {
                    JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName);
                }
                break block6;
            }
            try {
                Class<Driver> driverClass = module.getClassLoader().loadClass(driverClassName).asSubclass(Driver.class);
                Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                Driver driver = constructor.newInstance(new Object[0]);
                JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName);
            }
            catch (Exception e) {
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.cannotInstantiateDriverClass(driverClassName, e);
                throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.cannotInstantiateDriverClass(driverClassName)));
            }
        }
    }

    public static void startDriverServices(ServiceTarget target, ModuleIdentifier moduleId, Driver driver, String driverName, Integer majorVersion, Integer minorVersion, String dataSourceClassName, String xaDataSourceClassName) throws IllegalStateException {
        int majorVer = driver.getMajorVersion();
        int minorVer = driver.getMinorVersion();
        if (majorVersion != null && majorVersion != majorVer || minorVersion != null && minorVersion != minorVer) {
            throw ConnectorMessages.MESSAGES.driverVersionMismatch();
        }
        boolean compliant = driver.jdbcCompliant();
        if (compliant) {
            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.deployingCompliantJdbcDriver(driver.getClass(), majorVer, minorVer);
        } else {
            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.deployingNonCompliantJdbcDriver(driver.getClass(), majorVer, minorVer);
        }
        InstalledDriver driverMetadata = new InstalledDriver(driverName, moduleId, driver.getClass().getName(), dataSourceClassName, xaDataSourceClassName, majorVer, minorVer, compliant);
        DriverService driverService = new DriverService(driverMetadata, driver);
        target.addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

