/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.security.service.JaccService;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;

public class EjbJaccService
extends JaccService<EEModuleConfiguration> {
    public EjbJaccService(String contextId, EEModuleConfiguration metaData, Boolean standalone) {
        super(contextId, (Object)metaData, standalone);
    }

    public void createPermissions(EEModuleConfiguration metaData, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        Collection configurations = metaData.getComponentConfigurations();
        if (configurations != null) {
            for (ComponentConfiguration configuration : configurations) {
                SessionBeanComponentDescription session;
                ComponentDescription componentDescription = configuration.getComponentDescription();
                if (!(componentDescription instanceof EJBComponentDescription)) continue;
                EJBComponentDescription component = (EJBComponentDescription)((Object)EJBComponentDescription.class.cast(componentDescription));
                String ejbClassName = component.getEJBClassName();
                String ejbName = component.getEJBName();
                boolean denyOnAllViews = true;
                boolean permitOnAllViews = true;
                ArrayList<EJBMethodPermission> permissions = new ArrayList<EJBMethodPermission>();
                ArrayList<EJBMethodPermission> uncheckedPermissions = new ArrayList<EJBMethodPermission>();
                for (ViewDescription view : component.getViews()) {
                    EJBMethodPermission p;
                    MethodInterfaceType type;
                    EJBViewDescription ejbView;
                    MethodIdentifier identifier;
                    EJBMethodPermission p2;
                    MethodInterfaceType type2;
                    EJBViewDescription ejbView2;
                    String viewClassName = view.getViewClassName();
                    if (!component.isDenyAllApplicableToClass(viewClassName, ejbClassName)) {
                        denyOnAllViews = false;
                    } else {
                        ejbView2 = (EJBViewDescription)((Object)EJBViewDescription.class.cast(view));
                        type2 = this.getMethodInterfaceType(ejbView2.getMethodIntf());
                        p2 = new EJBMethodPermission(ejbName, null, type2.name(), null);
                        permissions.add(p2);
                    }
                    if (!component.isPermitAllApplicableToClass(viewClassName, ejbClassName)) {
                        permitOnAllViews = false;
                    } else {
                        ejbView2 = (EJBViewDescription)((Object)EJBViewDescription.class.cast(view));
                        type2 = this.getMethodInterfaceType(ejbView2.getMethodIntf());
                        p2 = new EJBMethodPermission(ejbName, null, type2.name(), null);
                        uncheckedPermissions.add(p2);
                    }
                    Set<String> roles = component.getRolesAllowedForClass(viewClassName, ejbClassName);
                    for (String role : roles) {
                        policyConfiguration.addToRole(role, (Permission)new EJBMethodPermission(ejbName, null, null, null));
                    }
                    Collection<EJBMethodIdentifier> methods = component.getDenyAllMethodsForView(viewClassName);
                    for (EJBMethodIdentifier method : methods) {
                        identifier = method.getMethodIdentifier();
                        ejbView = (EJBViewDescription)((Object)EJBViewDescription.class.cast(view));
                        type = this.getMethodInterfaceType(ejbView.getMethodIntf());
                        p = new EJBMethodPermission(ejbName, identifier.getName(), type.name(), identifier.getParameterTypes());
                        policyConfiguration.addToExcludedPolicy((Permission)p);
                    }
                    methods = component.getPermitAllMethodsForView(viewClassName);
                    for (EJBMethodIdentifier method : methods) {
                        identifier = method.getMethodIdentifier();
                        ejbView = (EJBViewDescription)((Object)EJBViewDescription.class.cast(view));
                        type = this.getMethodInterfaceType(ejbView.getMethodIntf());
                        p = new EJBMethodPermission(ejbName, identifier.getName(), type.name(), identifier.getParameterTypes());
                        policyConfiguration.addToUncheckedPolicy((Permission)p);
                    }
                    Map<EJBMethodIdentifier, Set<String>> rolesMap = component.getRolesAllowed(viewClassName);
                    for (Map.Entry<EJBMethodIdentifier, Set<String>> entry : rolesMap.entrySet()) {
                        MethodIdentifier identifier2 = entry.getKey().getMethodIdentifier();
                        EJBViewDescription ejbView3 = (EJBViewDescription)((Object)EJBViewDescription.class.cast(view));
                        MethodInterfaceType type3 = this.getMethodInterfaceType(ejbView3.getMethodIntf());
                        for (String role : entry.getValue()) {
                            EJBMethodPermission p3 = new EJBMethodPermission(ejbName, identifier2.getName(), type3.name(), identifier2.getParameterTypes());
                            policyConfiguration.addToRole(role, (Permission)p3);
                        }
                    }
                }
                if (denyOnAllViews) {
                    permissions = new ArrayList();
                    permissions.add(new EJBMethodPermission(ejbName, null, null, null));
                }
                for (EJBMethodPermission ejbMethodPermission : permissions) {
                    policyConfiguration.addToExcludedPolicy((Permission)ejbMethodPermission);
                }
                if (permitOnAllViews) {
                    uncheckedPermissions = new ArrayList();
                    uncheckedPermissions.add(new EJBMethodPermission(ejbName, null, null, null));
                }
                for (EJBMethodPermission ejbMethodPermission : uncheckedPermissions) {
                    policyConfiguration.addToUncheckedPolicy((Permission)ejbMethodPermission);
                }
                Map<String, Collection<String>> securityRoles = component.getSecurityRoleLinks();
                for (Map.Entry<String, Collection<String>> entry : securityRoles.entrySet()) {
                    String roleName = entry.getKey();
                    for (String roleLink : entry.getValue()) {
                        EJBRoleRefPermission p = new EJBRoleRefPermission(ejbName, roleName);
                        policyConfiguration.addToRole(roleLink, (Permission)p);
                    }
                }
                if (!(component instanceof SessionBeanComponentDescription) || !(session = (SessionBeanComponentDescription)((Object)SessionBeanComponentDescription.class.cast((Object)component))).isStateful()) continue;
                EJBMethodPermission p = new EJBMethodPermission(ejbName, "getEJBObject", "Home", null);
                policyConfiguration.addToUncheckedPolicy((Permission)p);
            }
        }
    }

    protected MethodInterfaceType getMethodInterfaceType(MethodIntf viewType) {
        switch (viewType) {
            case HOME: {
                return MethodInterfaceType.Home;
            }
            case LOCAL_HOME: {
                return MethodInterfaceType.LocalHome;
            }
            case SERVICE_ENDPOINT: {
                return MethodInterfaceType.ServiceEndpoint;
            }
            case LOCAL: {
                return MethodInterfaceType.Local;
            }
            case REMOTE: {
                return MethodInterfaceType.Remote;
            }
            case TIMER: {
                return MethodInterfaceType.Timer;
            }
            case MESSAGE_ENDPOINT: {
                return MethodInterfaceType.MessageEndpoint;
            }
        }
        return null;
    }
}

