/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.persistenceprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import org.jboss.as.jpa.JpaMessages;

public class PersistenceProviderResolverImpl
implements PersistenceProviderResolver {
    private List<Class> providers = new CopyOnWriteArrayList<Class>();
    private static final PersistenceProviderResolverImpl INSTANCE = new PersistenceProviderResolverImpl();

    public static PersistenceProviderResolverImpl getInstance() {
        return INSTANCE;
    }

    public List<PersistenceProvider> getPersistenceProviders() {
        ArrayList<PersistenceProvider> providersCopy = new ArrayList<PersistenceProvider>(this.providers.size());
        for (Class providerClass : this.providers) {
            try {
                providersCopy.add((PersistenceProvider)providerClass.newInstance());
            }
            catch (InstantiationException e) {
                throw JpaMessages.MESSAGES.couldNotCreateInstanceProvider((Throwable)e, providerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw JpaMessages.MESSAGES.couldNotCreateInstanceProvider((Throwable)e, providerClass.getName());
            }
        }
        return providersCopy;
    }

    public void clearCachedProviders() {
        this.providers.clear();
    }

    public void addPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.providers.add(persistenceProvider.getClass());
    }

    public void removePersistenceProvider(PersistenceProvider persistenceProvider) {
    }
}

