/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 20;
    private static final Log log = LogFactory.getLog(MapReduceCommand.class);
    protected Set<Object> keys;
    private Mapper mapper;
    private Reducer reducer;
    private InterceptorChain invoker;
    private CommandsFactory commandsFactory;
    protected InvocationContextContainer icc;
    protected DistributionManager dm;
    protected Address localAddress;

    private MapReduceCommand() {
        super(null);
    }

    public MapReduceCommand(String cacheName) {
        super(cacheName);
    }

    public MapReduceCommand(Mapper m, Reducer r, String cacheName, Object ... inputKeys) {
        super(cacheName);
        if (inputKeys == null || inputKeys.length == 0) {
            this.keys = new HashSet<Object>();
        } else {
            this.keys = new HashSet<Object>();
            this.keys.addAll(Arrays.asList(inputKeys));
        }
        this.mapper = m;
        this.reducer = r;
    }

    public MapReduceCommand(Mapper m, Reducer r, String cacheName, Collection<Object> inputKeys) {
        super(cacheName);
        this.keys = inputKeys == null || inputKeys.isEmpty() ? new HashSet<Object>() : new HashSet<Object>(inputKeys);
        this.mapper = m;
        this.reducer = r;
    }

    public void init(CommandsFactory factory, InterceptorChain invoker, InvocationContextContainer icc, DistributionManager dm, Address localAddress) {
        this.commandsFactory = factory;
        this.invoker = invoker;
        this.icc = icc;
        this.dm = dm;
        this.localAddress = localAddress;
    }

    @Override
    public Object perform(InvocationContext context) throws Throwable {
        boolean noInputKeys;
        InvocationContext ctx = this.getInvocationContext(context);
        boolean bl = noInputKeys = this.keys == null || this.keys.isEmpty();
        if (noInputKeys) {
            KeySetCommand keySetCommand = this.commandsFactory.buildKeySetCommand();
            Set nodeLocalKeys = (Set)this.invoker.invoke(ctx, keySetCommand);
            ArrayList selectedKeys = new ArrayList();
            for (Object e : nodeLocalKeys) {
                List<Address> locations = this.dm.locate(e);
                log.tracef("For key %s at %s owners are %s", e, this.localAddress, locations);
                if (locations == null || locations.isEmpty() || !locations.get(0).equals(this.localAddress)) continue;
                selectedKeys.add(e);
            }
            if (this.keys == null) {
                this.keys = new HashSet<Object>();
            }
            this.keys.addAll(selectedKeys);
        }
        log.tracef("For %s at %s invoking mapper on keys %s", this, this.localAddress, this.keys);
        DefaultCollector collector = new DefaultCollector();
        for (Object key : this.keys) {
            GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, ctx.getFlags());
            command.setReturnCacheEntry(false);
            Object object = this.invoker.invoke(ctx, command);
            this.mapper.map(key, object, collector);
        }
        Map collectedValues = collector.collectedValues();
        HashMap reducedMap = new HashMap();
        for (Map.Entry entry : collectedValues.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() > 1) {
                Object reduced = this.reducer.reduce(entry.getKey(), list.iterator());
                reducedMap.put(entry.getKey(), reduced);
                continue;
            }
            reducedMap.put(entry.getKey(), list.get(0));
        }
        log.tracef("%s executed at %s was reduced to %s", this, this.localAddress, reducedMap);
        return reducedMap;
    }

    @Override
    public byte getCommandId() {
        return 20;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.mapper, this.reducer};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 20) {
            throw new IllegalStateException("Invalid method id");
        }
        int i = 0;
        this.keys = (Set)args[i++];
        this.mapper = (Mapper)args[i++];
        this.reducer = (Reducer)args[i++];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapReduceCommand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapReduceCommand that = (MapReduceCommand)o;
        if (((Object)this.keys).equals(that.keys)) {
            return false;
        }
        if (this.mapper != null && this.reducer != null && that.mapper != null && that.reducer != null) {
            return this.mapper.getClass().equals(that.mapper.getClass()) && this.reducer.getClass().equals(that.reducer.getClass());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keys != null ? ((Object)this.keys).hashCode() : 0);
        result = 31 * result + (this.mapper != null ? this.mapper.getClass().hashCode() : 0);
        result = 31 * result + (this.reducer != null ? this.reducer.getClass().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "MapReduceCommand(keys=" + this.keys + ")";
    }

    private InvocationContext getInvocationContext(InvocationContext ctx) {
        return ctx == null ? this.icc.createRemoteInvocationContext(this.localAddress) : ctx;
    }

    private static class DefaultCollector<KOut, VOut>
    implements Collector<KOut, VOut> {
        private final Map<KOut, List<VOut>> store = new ConcurrentHashMap<KOut, List<VOut>>();

        private DefaultCollector() {
        }

        @Override
        public void emit(KOut key, VOut value) {
            List<VOut> list = this.store.get(key);
            if (list == null) {
                list = new LinkedList<VOut>();
                this.store.put(key, list);
            }
            list.add(value);
        }

        public Map<KOut, List<VOut>> collectedValues() {
            return this.store;
        }
    }
}

