/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.ReplicationQueueImpl;

public class AsyncConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder<AsyncConfiguration> {
    private boolean asyncMarshalling = false;
    private ReplicationQueue replicationQueue = new ReplicationQueueImpl();
    private long replicationQueueInterval = 5000L;
    private int replicationQueueMaxElements = 1000;
    private boolean useReplicationQueue = false;

    protected AsyncConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public AsyncConfigurationBuilder asyncMarshalling() {
        this.asyncMarshalling = true;
        return this;
    }

    public AsyncConfigurationBuilder syncMarshalling() {
        this.asyncMarshalling = false;
        return this;
    }

    public AsyncConfigurationBuilder replQueue(ReplicationQueue replicationQueue) {
        this.replicationQueue = replicationQueue;
        return this;
    }

    public AsyncConfigurationBuilder replQueueInterval(long interval) {
        this.replicationQueueInterval = interval;
        return this;
    }

    public AsyncConfigurationBuilder replQueueMaxElements(int elements) {
        this.replicationQueueMaxElements = elements;
        return this;
    }

    public AsyncConfigurationBuilder useReplQueue(boolean use) {
        this.useReplicationQueue = use;
        return this;
    }

    @Override
    void validate() {
    }

    @Override
    AsyncConfiguration create() {
        return new AsyncConfiguration(this.asyncMarshalling, this.replicationQueue, this.replicationQueueInterval, this.replicationQueueMaxElements, this.useReplicationQueue);
    }
}

