/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.StateTransferInProgressException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.TimeoutException;

public class StateTransferLockInterceptor
extends CommandInterceptor {
    public static final int RETRY_COUNT = 3;
    StateTransferLock stateTransferLock;

    @Inject
    public void injectDistributionManager(StateTransferLock stateTransferLock) {
        this.stateTransferLock = stateTransferLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            return this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    private Object signalStateTransferInProgress() {
        int viewId = this.stateTransferLock.getBlockingCacheViewId();
        throw new StateTransferInProgressException(viewId, "Timed out waiting for the state transfer lock, state transfer in progress for view " + viewId);
    }

    private Object handleWithRetries(InvocationContext ctx, VisitableCommand command) throws Throwable {
        int retries = 3;
        while (true) {
            int newCacheViewId;
            block5: {
                newCacheViewId = -1;
                try {
                    return this.invokeNextInterceptor(ctx, command);
                }
                catch (StateTransferInProgressException e) {
                    newCacheViewId = e.getNewCacheViewId();
                    if (retries < 0) {
                        throw new TimeoutException("Timed out waiting for the state transfer to end", (Throwable)((Object)e));
                    }
                }
                catch (SuspectException e) {
                    if (retries >= 0) break block5;
                    throw new TimeoutException("Timed out waiting for the state transfer to end", (Throwable)((Object)e));
                }
            }
            this.stateTransferLock.waitForStateTransferToEnd(ctx, command, newCacheViewId);
        }
    }
}

