/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.BaseStateTransferTask;
import org.infinispan.statetransfer.ReplicatedStateTransferManagerImpl;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplicatedStateTransferTask
extends BaseStateTransferTask {
    private static final Log log = LogFactory.getLog(ReplicatedStateTransferTask.class);
    private final ReplicatedStateTransferManagerImpl stateTransferManager;
    private long stateTransferStartMillis;

    public ReplicatedStateTransferTask(RpcManager rpcManager, Configuration configuration, DataContainer dataContainer, ReplicatedStateTransferManagerImpl stateTransferManager, StateTransferLock stateTransferLock, CacheNotifier cacheNotifier, int newViewId, Collection<Address> members, ConsistentHash chOld, ConsistentHash chNew, boolean initialView) {
        super(stateTransferManager, rpcManager, stateTransferLock, cacheNotifier, configuration, dataContainer, members, newViewId, chNew, chOld, initialView);
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public void doPerformStateTransfer() throws Exception {
        Set<Address> joiners;
        if (!this.stateTransferManager.startStateTransfer(this.newViewId, this.members, this.initialView)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Commencing state transfer %d on node: %s. Before start, data container had %d entries", this.newViewId, this.self, this.dataContainer.size());
        }
        this.stateTransferLock.blockNewTransactions(this.newViewId);
        Set<Address> set = joiners = this.chOld != null ? MembershipArithmetic.getMembersJoined(this.chOld.getCaches(), this.chNew.getCaches()) : this.chNew.getCaches();
        if (joiners.isEmpty()) {
            log.tracef("No joiners in view %s, skipping replication", this.newViewId);
        } else {
            log.tracef("Replicating: chOld = %s, chNew = %s", this.chOld, this.chNew);
            if (this.configuration.isStateTransferEnabled() && !this.initialView) {
                ArrayList<InternalCacheEntry> state = new ArrayList<InternalCacheEntry>();
                for (InternalCacheEntry ice : this.dataContainer) {
                    this.replicate(ice.getKey(), ice, this.chOld, this.chNew, null, state);
                }
                CacheStore cacheStore = this.stateTransferManager.getCacheStoreForStateTransfer();
                if (cacheStore != null) {
                    for (Object key : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                        this.replicate(key, null, this.chOld, this.chNew, cacheStore, state);
                    }
                } else if (this.trace) {
                    log.trace("No cache store or cache store is shared, not replicating stored keys");
                }
                HashMap<Address, Collection<InternalCacheEntry>> states = new HashMap<Address, Collection<InternalCacheEntry>>();
                for (Address joiner : joiners) {
                    states.put(joiner, state);
                }
                this.pushState(states);
            } else if (!this.initialView) {
                log.trace("State transfer not enabled, so not pushing state");
            }
        }
    }

    private void replicate(Object key, InternalCacheEntry value, ConsistentHash chOld, ConsistentHash chNew, CacheStore cacheStore, Collection<InternalCacheEntry> state) {
        Address pushingOwner;
        List<Address> oldOwners = chOld.locate(key, 1);
        Address address = pushingOwner = oldOwners.size() > 0 ? oldOwners.get(0) : null;
        if (this.trace) {
            log.tracef("Replicating key %s, pushing owner is %s", key, pushingOwner);
        }
        if (this.self.equals(pushingOwner)) {
            if (value == null) {
                try {
                    value = cacheStore.load(key);
                }
                catch (CacheLoaderException e) {
                    log.failedLoadingValueFromCacheStore(key);
                }
            }
            if (value != null) {
                state.add(value);
            }
        }
    }
}

