/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.security.SecurityDomainContextAdaptor;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SecurityUtil;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class EndpointService
implements Service<Endpoint> {
    private final Endpoint endpoint;
    private final ServiceName name;
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();

    private EndpointService(Endpoint endpoint, ServiceName name) {
        this.endpoint = endpoint;
        this.name = name;
    }

    public Endpoint getValue() {
        return this.endpoint;
    }

    public static ServiceName getServiceName(DeploymentUnit unit, String endpointName) {
        if (unit.getParent() != null) {
            return WSServices.ENDPOINT_SERVICE.append(new String[]{unit.getParent().getName()}).append(new String[]{unit.getName()}).append(new String[]{endpointName});
        }
        return WSServices.ENDPOINT_SERVICE.append(new String[]{unit.getName()}).append(new String[]{endpointName});
    }

    public void start(StartContext context) throws StartException {
        WSLogger.ROOT_LOGGER.starting(this.name);
        this.endpoint.setSecurityDomainContext((org.jboss.wsf.spi.security.SecurityDomainContext)new SecurityDomainContextAdaptor((SecurityDomainContext)this.securityDomainContextValue.getValue()));
    }

    public void stop(StopContext context) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        this.endpoint.setSecurityDomainContext(null);
    }

    public Injector<SecurityDomainContext> getSecurityDomainContextInjector() {
        return this.securityDomainContextValue;
    }

    public static void install(ServiceTarget serviceTarget, Endpoint endpoint, DeploymentUnit unit) {
        ServiceName serviceName = EndpointService.getServiceName(unit, endpoint.getShortName());
        EndpointService service = new EndpointService(endpoint, serviceName);
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{EndpointService.getDeploymentSecurityDomainName(endpoint)}), SecurityDomainContext.class, service.getSecurityDomainContextInjector());
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    private static String getDeploymentSecurityDomainName(Endpoint ep) {
        JBossWebMetaData metadata = (JBossWebMetaData)ep.getService().getDeployment().getAttachment(JBossWebMetaData.class);
        String metaDataSecurityDomain = metadata != null ? metadata.getSecurityDomain() : null;
        return metaDataSecurityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain.trim());
    }
}

