/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.Serializable;
import org.jboss.invocation.ChainedInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.InvocationMessages;

final class ChainedInterceptorFactory
implements InterceptorFactory,
Serializable {
    private static final long serialVersionUID = -4300168217824335867L;
    private final InterceptorFactory[] interceptorFactories;

    ChainedInterceptorFactory(InterceptorFactory ... interceptorFactories) {
        if (interceptorFactories == null) {
            throw InvocationMessages.msg.nullParameter("interceptorFactories");
        }
        this.interceptorFactories = interceptorFactories;
    }

    @Override
    public Interceptor create(InterceptorFactoryContext context) {
        InterceptorFactory[] factories = this.interceptorFactories;
        int length = factories.length;
        Interceptor[] interceptors = new Interceptor[length];
        for (int i = 0; i < length; ++i) {
            interceptors[i] = factories[i].create(context);
        }
        return new ChainedInterceptor(interceptors);
    }
}

