/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectReference
extends Reference {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DirectReference.class);
    private Document doc;
    private String uri;
    private String valueType;
    private Element cachedElement;

    public DirectReference(Document doc) {
        this.doc = doc;
    }

    public DirectReference(Document doc, BinarySecurityToken token) {
        this.doc = doc;
        this.referenceToken(token);
    }

    public DirectReference(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        if (!"Reference".equals(element.getLocalName())) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_LOCAL_NAME", (Object[])new Object[0]));
        }
        String uri = element.getAttribute("URI");
        if (uri == null || uri.length() == 0) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MISSING_URI", (Object[])new Object[0]));
        }
        this.setUri(uri);
        String valueType = element.getAttribute("ValueType");
        if (valueType == null || valueType.length() == 0) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MISSING_VALUETYPE", (Object[])new Object[0]));
        }
        this.setValueType(valueType);
    }

    public String getUri() {
        return this.uri;
    }

    public void referenceToken(BinarySecurityToken token) {
        this.setUri("#" + token.getId());
        this.setValueType(token.getValueType());
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    @Override
    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        element.setAttribute("ValueType", this.getValueType());
        element.setAttribute("URI", this.getUri());
        this.cachedElement = element;
        return this.cachedElement;
    }
}

