/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.SimplePrincipal;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.exception.FailedAuthenticationException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.metadata.wsse.Authorize;
import org.jboss.ws.metadata.wsse.Role;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.spi.security.SecurityDomainContext;

public class AuthorizeOperation {
    private static final ResourceBundle bundle = BundleUtils.getBundle(AuthorizeOperation.class);
    private static final Logger log = Logger.getLogger(AuthorizeOperation.class);
    private Authorize authorize;
    private SecurityAdaptorFactory secAdapterfactory;
    private SecurityDomainContext sdc;

    public AuthorizeOperation(Authorize authorize) {
        this.authorize = authorize;
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
        this.secAdapterfactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class, cl);
        Endpoint ep = EndpointAssociation.getEndpoint();
        if (ep != null) {
            this.sdc = ep.getSecurityDomainContext();
        }
    }

    public void process() throws WSSecurityException {
        Subject subject;
        boolean TRACE = log.isTraceEnabled();
        if (TRACE) {
            log.trace((Object)("About to check authorization, using security domain '" + this.sdc.getSecurityDomain() + "'"));
        }
        SecurityAdaptor securityAdaptor = this.secAdapterfactory.newSecurityAdapter();
        Principal principal = securityAdaptor.getPrincipal();
        Object credential = securityAdaptor.getCredential();
        if (principal == null) {
            principal = new Principal(){

                @Override
                public String getName() {
                    return null;
                }
            };
        }
        if (!this.sdc.isValid(principal, credential, subject = new Subject())) {
            String msg = BundleUtils.getMessage((ResourceBundle)bundle, (String)"AUTHENTICATION_FAILED", (Object[])new Object[]{principal});
            log.error((Object)msg);
            SecurityException e = new SecurityException(msg);
            throw new FailedAuthenticationException(e);
        }
        this.sdc.pushSubjectContext(subject, principal, credential);
        if (TRACE) {
            log.trace((Object)("Authenticated, principal=" + principal));
        }
        if (this.authorize.isUnchecked()) {
            if (TRACE) {
                log.trace((Object)"authorize.isUnchecked()==true skipping roles check.");
            }
            return;
        }
        Set<Principal> expectedRoles = this.expectedRoles();
        if (TRACE) {
            log.trace((Object)("expectedRoles=" + expectedRoles));
        }
        if (!this.sdc.doesUserHaveRole(principal, expectedRoles)) {
            Set userRoles = this.sdc.getUserRoles(principal);
            String msg = BundleUtils.getMessage((ResourceBundle)bundle, (String)"INSUFFICIENT_METHOD_PERMISSIONS", (Object[])new Object[]{principal, expectedRoles, userRoles});
            log.error((Object)msg);
            SecurityException e = new SecurityException(msg);
            throw new FailedAuthenticationException(e);
        }
        if (TRACE) {
            log.trace((Object)("Roles check complete, principal=" + principal + ", requiredRoles=" + expectedRoles));
        }
    }

    private Set<Principal> expectedRoles() {
        List<Role> roles = this.authorize.getRoles();
        int rolesCount = roles != null ? roles.size() : 0;
        HashSet<Principal> expectedRoles = new HashSet<Principal>(rolesCount);
        if (roles != null) {
            for (Role current : roles) {
                expectedRoles.add((Principal)new SimplePrincipal(current.getName()));
            }
        }
        return expectedRoles;
    }
}

