/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.mux;

import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.UpHandler;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.mux.MuxRequestCorrelator;
import org.jgroups.blocks.mux.MuxUpHandler;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.blocks.mux.NoMuxHandlerRspFilter;
import org.jgroups.stack.Protocol;

public class MuxMessageDispatcher
extends MessageDispatcher {
    private final short scope_id;

    public MuxMessageDispatcher(short scopeId) {
        this.scope_id = scopeId;
    }

    public MuxMessageDispatcher(short scopeId, Channel channel, MessageListener messageListener, MembershipListener membershipListener, RequestHandler handler) {
        this(scopeId);
        this.setMessageListener(messageListener);
        this.setMembershipListener(membershipListener);
        this.setChannel(channel);
        this.setRequestHandler(handler);
        this.start();
    }

    private Muxer<UpHandler> getMuxer() {
        UpHandler handler = this.channel.getUpHandler();
        return handler != null && handler instanceof MuxUpHandler ? (MuxUpHandler)handler : null;
    }

    @Override
    protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address localAddr) {
        return new MuxRequestCorrelator(this.scope_id, transport, handler, localAddr);
    }

    @Override
    public void start() {
        super.start();
        Muxer<UpHandler> muxer = this.getMuxer();
        if (muxer != null) {
            muxer.add(this.scope_id, this.getProtocolAdapter());
        }
    }

    @Override
    public void stop() {
        Muxer<UpHandler> muxer = this.getMuxer();
        if (muxer != null) {
            muxer.remove(this.scope_id);
        }
        super.stop();
    }

    @Override
    protected <T> GroupRequest<T> cast(Collection<Address> dests, Message msg, RequestOptions options, boolean blockForResults) throws Exception {
        RspFilter filter = options.getRspFilter();
        RequestOptions newOptions = new RequestOptions(options.getMode(), options.getTimeout(), options.getAnycasting(), filter != null ? new NoMuxHandlerRspFilter(filter) : new NoMuxHandlerRspFilter(), options.getFlags());
        return super.cast(dests, msg, newOptions, blockForResults);
    }
}

