/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class BridgeRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    public static final BridgeRemove INSTANCE = new BridgeRemove();

    private BridgeRemove() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName hqServiceName;
        String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null && hqService.getState() == ServiceController.State.UP) {
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            try {
                server.getHornetQServerControl().destroyBridge(name);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null && hqService.getState() == ServiceController.State.UP) {
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            BridgeConfiguration bridgeConfiguration = BridgeAdd.createBridgeConfiguration(context, name, model);
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            BridgeAdd.createBridge(name, bridgeConfiguration, (HornetQServerControl)server.getHornetQServerControl());
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getBridgeRemove(locale);
    }
}

