/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.UnconfiguredComponentHolder;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;

public class ComponentRegistry
implements ScrService {
    private final Map m_componentHoldersByName = new HashMap();
    private final Map m_componentsById = new HashMap();
    private volatile long m_componentCounter = -1L;
    private ServiceRegistration m_registration;
    static /* synthetic */ Class class$org$apache$felix$scr$ScrService;

    protected ComponentRegistry(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Management Agent");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = context.registerService(new String[]{(class$org$apache$felix$scr$ScrService == null ? (class$org$apache$felix$scr$ScrService = ComponentRegistry.class$("org.apache.felix.scr.ScrService")) : class$org$apache$felix$scr$ScrService).getName()}, (Object)this, props);
    }

    public void dispose() {
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    public Component[] getComponents() {
        Object[] holders = this.getComponentHolders();
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < holders.length; ++i) {
            if (!(holders[i] instanceof ComponentHolder)) continue;
            Component[] components = ((ComponentHolder)holders[i]).getComponents();
            for (int j = 0; j < components.length; ++j) {
                list.add(components[j]);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Component[list.size()]);
    }

    public Component[] getComponents(Bundle bundle) {
        Object[] holders = this.getComponentHolders();
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < holders.length; ++i) {
            ComponentHolder holder;
            BundleComponentActivator activator;
            if (!(holders[i] instanceof ComponentHolder) || (activator = (holder = (ComponentHolder)holders[i]).getActivator()) == null || activator.getBundleContext().getBundle() != bundle) continue;
            Component[] components = holder.getComponents();
            for (int j = 0; j < components.length; ++j) {
                list.add(components[j]);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Component[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(long componentId) {
        Map map = this.m_componentsById;
        synchronized (map) {
            return (Component)this.m_componentsById.get(new Long(componentId));
        }
    }

    public Component[] getComponents(String componentName) {
        ComponentHolder holder = this.getComponentHolder(componentName);
        if (holder != null) {
            return holder.getComponents();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long registerComponentId(AbstractComponentManager componentManager) {
        long componentId;
        Map map = this.m_componentsById;
        synchronized (map) {
            ++this.m_componentCounter;
            componentId = this.m_componentCounter;
            this.m_componentsById.put(new Long(componentId), componentManager);
        }
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentId(long componentId) {
        Map map = this.m_componentsById;
        synchronized (map) {
            this.m_componentsById.remove(new Long(componentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkComponentName(String name) {
        Object existingRegistration;
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            existingRegistration = this.m_componentHoldersByName.get(name);
            if (existingRegistration == null) {
                this.m_componentHoldersByName.put(name, name);
            }
        }
        if (existingRegistration != null) {
            String message = "The component name '" + name + "' has already been registered";
            if (existingRegistration instanceof ComponentHolder) {
                ComponentHolder c = (ComponentHolder)existingRegistration;
                Bundle cBundle = c.getActivator().getBundleContext().getBundle();
                ComponentMetadata cMeta = c.getComponentMetadata();
                StringBuffer buf = new StringBuffer(message);
                buf.append(" by Bundle ").append(cBundle.getBundleId());
                if (cBundle.getSymbolicName() != null) {
                    buf.append(" (").append(cBundle.getSymbolicName()).append(")");
                }
                buf.append(" as Component of Class ").append(cMeta.getImplementationClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerComponentHolder(String name, ComponentHolder component) {
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            if (!name.equals(this.m_componentHoldersByName.get(name))) {
                throw new ComponentException("The component name '" + name + "' has already been registered.");
            }
            this.m_componentHoldersByName.put(name, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentHolder getComponentHolder(String name) {
        Object entry;
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            entry = this.m_componentHoldersByName.get(name);
        }
        if (entry instanceof ComponentHolder) {
            return (ComponentHolder)entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getComponentHolders() {
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            return this.m_componentHoldersByName.values().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentHolder(String name) {
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            this.m_componentHoldersByName.remove(name);
        }
    }

    public ComponentHolder createComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        if (metadata.isFactory()) {
            return new ComponentFactoryImpl(activator, metadata);
        }
        return new UnconfiguredComponentHolder(activator, metadata);
    }

    static boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders().get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

