/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.mgmt.ManagementByeByeHeader;
import org.jboss.as.protocol.mgmt.ManagementPingHeader;
import org.jboss.as.protocol.mgmt.ManagementPongHeader;
import org.jboss.as.protocol.mgmt.ManagementProtocol;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;

abstract class ManagementProtocolHeader {
    private int version;

    protected ManagementProtocolHeader(int version) {
        this.version = version;
    }

    public void write(DataOutput output) throws IOException {
        output.write(ManagementProtocol.SIGNATURE);
        output.writeByte(0);
        output.writeInt(this.getVersion());
        output.writeByte(1);
        output.writeByte(this.getType());
    }

    public int getVersion() {
        return this.version;
    }

    abstract byte getType();

    protected static void validateSignature(DataInput input) throws IOException {
        byte[] signatureBytes = new byte[4];
        input.readFully(signatureBytes);
        if (!Arrays.equals(ManagementProtocol.SIGNATURE, signatureBytes)) {
            throw ProtocolMessages.MESSAGES.invalidSignature(Arrays.toString(signatureBytes));
        }
    }

    static ManagementProtocolHeader parse(DataInput input) throws IOException {
        ManagementProtocolHeader.validateSignature(input);
        ProtocolUtils.expectHeader(input, 0);
        int version = input.readInt();
        ProtocolUtils.expectHeader(input, 1);
        byte type = input.readByte();
        switch (type) {
            case 2: {
                return new ManagementRequestHeader(version, input);
            }
            case 3: {
                return new ManagementResponseHeader(version, input);
            }
            case 4: {
                return new ManagementByeByeHeader(version);
            }
            case 5: {
                return new ManagementPingHeader(version);
            }
            case 6: {
                return new ManagementPongHeader(version);
            }
        }
        throw ProtocolMessages.MESSAGES.invalidType("0x" + Integer.toHexString(type));
    }
}

