/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.Level;

final class LogLevelValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    private static final java.util.logging.Level[] LEVELS = new java.util.logging.Level[]{Level.ALL, Level.CONFIG, Level.DEBUG, Level.ERROR, Level.FATAL, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.OFF, Level.TRACE, Level.WARN, Level.WARNING};
    private final List<java.util.logging.Level> allowedValues;
    private final List<ModelNode> nodeValues;

    public LogLevelValidator(boolean nullable) {
        this(nullable, false);
    }

    public LogLevelValidator(boolean nullable, java.util.logging.Level ... levels) {
        this(nullable, false, levels);
    }

    public LogLevelValidator(boolean nullable, boolean allowExpressions) {
        this(nullable, allowExpressions, LEVELS);
    }

    public LogLevelValidator(boolean nullable, boolean allowExpressions, java.util.logging.Level ... levels) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.allowedValues = Arrays.asList(levels);
        this.nodeValues = new ArrayList<ModelNode>(this.allowedValues.size());
        for (java.util.logging.Level level : this.allowedValues) {
            this.nodeValues.add(new ModelNode().set(level.getName()));
        }
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            String levelString = value.asString();
            try {
                java.util.logging.Level level = ModelParser.parseLevel(value);
                if (!this.allowedValues.contains(level)) {
                    throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidLogLevel(levelString)));
                }
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidLogLevel(levelString)));
            }
        }
    }

    public List<ModelNode> getAllowedValues() {
        return this.nodeValues;
    }
}

