/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.AbstractLoggerWriteAttributeHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

class LoggerWriteAttributeHandler
extends AbstractLoggerWriteAttributeHandler {
    public static final LoggerWriteAttributeHandler INSTANCE = new LoggerWriteAttributeHandler();

    private LoggerWriteAttributeHandler() {
        super((AttributeDefinition)CommonAttributes.LEVEL, new AttributeDefinition[]{CommonAttributes.FILTER, CommonAttributes.USE_PARENT_HANDLERS});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Logger> handbackHolder) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController controller = serviceRegistry.getService(LogServices.loggerName(name));
        if (controller == null) {
            return false;
        }
        Logger logger2 = (Logger)controller.getValue();
        if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
            logger2.setLevel(ModelParser.parseLevel(resolvedValue));
        } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
            logger2.setFilter(ModelParser.parseFilter(context, resolvedValue));
        } else if (CommonAttributes.USE_PARENT_HANDLERS.getName().equals(attributeName)) {
            logger2.setUseParentHandlers(resolvedValue.asBoolean());
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Logger logger2) throws OperationFailedException {
        if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
            logger2.setLevel(ModelParser.parseLevel(valueToRestore));
        } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
            logger2.setFilter(ModelParser.parseFilter(context, valueToRestore));
        } else if (CommonAttributes.USE_PARENT_HANDLERS.getName().equals(attributeName)) {
            logger2.setUseParentHandlers(valueToRestore.asBoolean());
        }
    }
}

