/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.FlushingHandlerAddProperties;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.PeriodicRotatingFileHandlerService;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class PeriodicRotatingFileHandlerAdd
extends FlushingHandlerAddProperties<PeriodicRotatingFileHandlerService> {
    static final PeriodicRotatingFileHandlerAdd INSTANCE = new PeriodicRotatingFileHandlerAdd();

    private PeriodicRotatingFileHandlerAdd() {
        super(new AttributeDefinition[]{CommonAttributes.FILE, CommonAttributes.APPEND, CommonAttributes.SUFFIX});
    }

    @Override
    protected PeriodicRotatingFileHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new PeriodicRotatingFileHandlerService();
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, PeriodicRotatingFileHandlerService service, ModelNode model) throws OperationFailedException {
        ModelNode suffix;
        ModelNode append;
        super.updateRuntime(context, serviceBuilder, name, service, model);
        ModelNode file = CommonAttributes.FILE.resolveModelAttribute(context, model);
        if (file.isDefined()) {
            ServiceTarget serviceTarget = context.getServiceTarget();
            HandlerFileService fileService = new HandlerFileService(CommonAttributes.PATH.resolveModelAttribute(context, file).asString());
            ServiceBuilder fileBuilder = serviceTarget.addService(LogServices.handlerFileName(name), (Service)fileService);
            ModelNode relativeTo = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, file);
            if (relativeTo.isDefined()) {
                fileBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo.asString()), String.class, fileService.getRelativeToInjector());
            }
            fileBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            serviceBuilder.addDependency(LogServices.handlerFileName(name), String.class, service.getFileNameInjector());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, model)).isDefined()) {
            service.setAppend(append.asBoolean());
        }
        if ((suffix = CommonAttributes.SUFFIX.resolveModelAttribute(context, model)).isDefined()) {
            service.setSuffix(suffix.asString());
        }
    }
}

