/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.FlushingHandlerAddProperties;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.ModelParser;
import org.jboss.as.logging.SizeRotatingFileHandlerService;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

class SizeRotatingFileHandlerAdd
extends FlushingHandlerAddProperties<SizeRotatingFileHandlerService> {
    static final SizeRotatingFileHandlerAdd INSTANCE = new SizeRotatingFileHandlerAdd();

    private SizeRotatingFileHandlerAdd() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.FILE, CommonAttributes.MAX_BACKUP_INDEX, CommonAttributes.ROTATE_SIZE});
    }

    @Override
    protected SizeRotatingFileHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new SizeRotatingFileHandlerService();
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, SizeRotatingFileHandlerService service, ModelNode model) throws OperationFailedException {
        ModelNode rotateSizeNode;
        ModelNode maxBackupIndex;
        ModelNode file;
        super.updateRuntime(context, serviceBuilder, name, service, model);
        ModelNode append = CommonAttributes.APPEND.resolveModelAttribute(context, model);
        if (append.isDefined()) {
            service.setAppend(append.asBoolean());
        }
        if ((file = CommonAttributes.FILE.resolveModelAttribute(context, model)).isDefined()) {
            HandlerFileService fileService = new HandlerFileService(CommonAttributes.PATH.resolveModelAttribute(context, file).asString());
            ServiceBuilder fileBuilder = context.getServiceTarget().addService(LogServices.handlerFileName(name), (Service)fileService);
            ModelNode relativeTo = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, file);
            if (relativeTo.isDefined()) {
                fileBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo.asString()), String.class, fileService.getRelativeToInjector());
            }
            fileBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            serviceBuilder.addDependency(LogServices.handlerFileName(name), String.class, service.getFileNameInjector());
        }
        if ((maxBackupIndex = CommonAttributes.MAX_BACKUP_INDEX.resolveModelAttribute(context, model)).isDefined()) {
            service.setMaxBackupIndex(maxBackupIndex.asInt());
        }
        if ((rotateSizeNode = CommonAttributes.ROTATE_SIZE.resolveModelAttribute(context, model)).isDefined()) {
            service.setRotateSize(ModelParser.parseSize(rotateSizeNode));
        }
    }
}

