/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.javaee;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.AbstractWebAuthorizationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAuthorizationHelper
extends AbstractWebAuthorizationHelper {
    protected static Logger log = Logger.getLogger(WebAuthorizationHelper.class);

    @Override
    public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, String contextID, String canonicalRequestURI) {
        return this.checkResourcePermission(contextMap, request, response, callerSubject, contextID, canonicalRequestURI, null);
    }

    @Override
    public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, String contextID, String canonicalRequestURI, List<String> roles) {
        boolean isAuthorized;
        block12: {
            if (contextID == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:ContextID is null");
            }
            if (request == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:request is null");
            }
            if (response == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:response is null");
            }
            if (canonicalRequestURI == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:canonicalRequestURI is null");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw new IllegalStateException("PB00015: Null Value:Authorization Manager is null");
            }
            isAuthorized = false;
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(contextID);
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            webResource.setCanonicalRequestURI(canonicalRequestURI);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = null;
            if (roles == null) {
                callerRoles = authzMgr.getSubjectRoles(callerSubject, sch);
            } else {
                callerRoles = new SimpleRoleGroup("Roles");
                for (String role : roles) {
                    callerRoles.addRole(new SimpleRole(role));
                }
            }
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                isAuthorized = permit == 1;
                String string = level = permit == 1 ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                isAuthorized = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasResourcePermission check failed:" + e.getLocalizedMessage()), (Throwable)e);
                }
                if (!this.enableAudit) break block12;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return isAuthorized;
    }

    @Override
    public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, String contextID, Subject callerSubject) {
        return this.hasRole(roleName, principal, servletName, principalRoles, contextID, callerSubject, null);
    }

    @Override
    public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, String contextID, Subject callerSubject, List<String> roles) {
        boolean hasTheRole;
        block11: {
            if (roleName == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:roleName is null");
            }
            if (contextID == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:ContextID is null");
            }
            if (callerSubject == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:callerSubject is null");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw new IllegalStateException("PB00015: Null Value:Authorization Manager is null");
            }
            hasTheRole = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleName", roleName);
            map.put("roleRefPermissionCheck", Boolean.TRUE);
            map.put("principal.roles", principalRoles);
            map.put("policyRegistration", this.getPolicyRegistration());
            WebResource webResource = new WebResource(Collections.unmodifiableMap(map));
            webResource.setPolicyContextID(contextID);
            webResource.setPrincipal(principal);
            webResource.setServletName(servletName);
            webResource.setCallerSubject(callerSubject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = null;
            if (roles == null) {
                callerRoles = authzMgr.getSubjectRoles(callerSubject, sch);
            } else {
                callerRoles = new SimpleRoleGroup("Roles");
                for (String role : roles) {
                    callerRoles.addRole(new SimpleRole(role));
                }
            }
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                hasTheRole = permit == 1;
                String string = level = hasTheRole ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasTheRole = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasRole check failed:" + e.getLocalizedMessage()), (Throwable)e);
                }
                if (!this.enableAudit) break block11;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return hasTheRole;
    }

    @Override
    public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, String contextID, Subject callerSubject) {
        return this.hasUserDataPermission(contextMap, request, response, contextID, callerSubject, null);
    }

    @Override
    public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, String contextID, Subject callerSubject, List<String> roles) {
        boolean hasPerm;
        block12: {
            if (contextID == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:ContextID is null");
            }
            if (callerSubject == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:callerSubject is null");
            }
            if (request == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:request is null");
            }
            if (response == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:response is null");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw new IllegalStateException("PB00015: Null Value:Authorization Manager is null");
            }
            hasPerm = false;
            contextMap.put("policyRegistration", this.getPolicyRegistration());
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(contextID);
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = null;
            if (roles == null) {
                callerRoles = authzMgr.getSubjectRoles(callerSubject, sch);
            } else {
                callerRoles = new SimpleRoleGroup("Roles");
                for (String role : roles) {
                    callerRoles.addRole(new SimpleRole(role));
                }
            }
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                hasPerm = permit == 1;
                String string = level = hasPerm ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasPerm = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasRole check failed:" + e.getLocalizedMessage()), (Throwable)e);
                }
                if (!this.enableAudit) break block12;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return hasPerm;
    }
}

