/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.NoSuchElementException;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class RestartParentResourceRemoveHandler
extends AbstractRemoveStepHandler {
    private final String parentKeyName;

    protected RestartParentResourceRemoveHandler(String parentKeyName) {
        this.parentKeyName = parentKeyName;
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceController service;
        if (context.isBooting()) {
            return;
        }
        PathAddress address = this.getParentAddress(PathAddress.pathAddress(operation.require("address")));
        ServiceName serviceName = this.getParentServiceName(address);
        ServiceController serviceController = service = serviceName != null ? context.getServiceRegistry(false).getService(serviceName) : null;
        if (service == null) {
            return;
        }
        if (context.isResourceServiceRestartAllowed()) {
            ModelNode parentModel = this.getModel(context, address);
            if (parentModel != null && context.markResourceRestarted(address, this)) {
                context.removeService(serviceName);
                ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                this.recreateParentService(context, address, parentModel, verificationHandler);
                context.addStep(verificationHandler, OperationContext.Stage.VERIFY);
            }
        } else {
            context.reloadRequired();
        }
    }

    protected abstract void recreateParentService(OperationContext var1, PathAddress var2, ModelNode var3, ServiceVerificationHandler var4);

    protected abstract ServiceName getParentServiceName(PathAddress var1);

    protected PathAddress getParentAddress(PathAddress address) {
        return Util.getParentAddressByKey(address, this.parentKeyName);
    }

    @Override
    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceController service;
        PathAddress address = this.getParentAddress(PathAddress.pathAddress(operation.require("address")));
        ServiceName serviceName = this.getParentServiceName(address);
        ServiceController serviceController = service = serviceName != null ? context.getServiceRegistry(false).getService(serviceName) : null;
        if (service == null) {
            return;
        }
        if (context.isResourceServiceRestartAllowed()) {
            ModelNode parentModel = this.getOriginalModel(context, address);
            if (parentModel != null && context.revertResourceRestarted(address, this)) {
                context.removeService(serviceName);
                this.recreateParentService(context, address, parentModel, null);
            }
        } else {
            context.revertReloadRequired();
        }
    }

    private ModelNode getModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.getRootResource().navigate(address);
            return Resource.Tools.readModel(resource);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private ModelNode getOriginalModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.getOriginalRootResource().navigate(address);
            return Resource.Tools.readModel(resource);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

