/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AbstractLogHandlerAssignmentHandler;
import org.jboss.as.logging.AsyncHandlerService;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class AsyncHandlerUnassignSubhandler
extends AbstractLogHandlerAssignmentHandler {
    static final String OPERATION_NAME = "unassign-subhandler";
    static final AsyncHandlerUnassignSubhandler INSTANCE = new AsyncHandlerUnassignSubhandler();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.updateHandlersForUnassign((AttributeDefinition)CommonAttributes.SUBHANDLERS, operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String asyncHandlerName = address.getLastElement().getValue();
        String handlerNameToRemove = CommonAttributes.NAME.resolveModelAttribute(context, model).asString();
        AsyncHandlerUnassignSubhandler.removeHandler(context, asyncHandlerName, handlerNameToRemove);
    }

    @Override
    protected String getHandlerName(ModelNode model) throws OperationFailedException {
        return CommonAttributes.NAME.validateOperation(model).asString();
    }

    public static void removeHandler(OperationContext context, String asyncHandlerName, String handlerNameToRemove) throws OperationFailedException {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController handlerController = serviceRegistry.getService(LogServices.handlerName(asyncHandlerName));
        ServiceController handlerToRemoveController = serviceRegistry.getService(LogServices.handlerName(handlerNameToRemove));
        AsyncHandlerService service = (AsyncHandlerService)AsyncHandlerService.class.cast(handlerController.getService());
        Handler injectedHandler = (Handler)handlerToRemoveController.getService().getValue();
        service.removeHandler(injectedHandler);
    }

    public static void removeHandlers(AttributeDefinition attribute, ModelNode node, OperationContext context, String asyncHandlerName) throws OperationFailedException {
        ModelNode handlers = attribute.resolveModelAttribute(context, node);
        if (handlers.isDefined() && handlers.getType() == ModelType.LIST) {
            for (ModelNode handler : handlers.asList()) {
                AsyncHandlerUnassignSubhandler.removeHandler(context, asyncHandlerName, handler.asString());
            }
        }
    }
}

