/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ModClusterMessages;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ModClusterAddCustomMetric
implements OperationStepHandler,
DescriptionProvider {
    static final ModClusterAddCustomMetric INSTANCE = new ModClusterAddCustomMetric();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getAddCustomMetricDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode dynamicLoadProvider = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("dynamic-load-provider");
                    ModelNode metric = new ModelNode();
                    List list = operation.asPropertyList();
                    for (Property prop : list) {
                        if (prop.getName().equals("property")) {
                            String properties = prop.getValue().asString();
                            ModelNode props = ModelNode.fromString((String)properties);
                            metric.get("property").set(props);
                            continue;
                        }
                        metric.get(prop.getName()).set(prop.getValue().asString());
                    }
                    if (!metric.get("class").isDefined()) {
                        throw new OperationFailedException(new ModelNode().set(ModClusterMessages.MESSAGES.classAttributeRequired("add-custom-metric")));
                    }
                    if (!dynamicLoadProvider.isDefined()) {
                        dynamicLoadProvider.get("history").set(9);
                        dynamicLoadProvider.get("decay").set(2);
                    }
                    this.replaceMetric(dynamicLoadProvider, metric);
                    context.completeStep();
                }

                private void replaceMetric(ModelNode dynamicLoadProvider, ModelNode metric) {
                    List newlist = Collections.emptyList();
                    if (dynamicLoadProvider.get("custom-load-metric").isDefined()) {
                        String classname = metric.get("class").asString();
                        List list = dynamicLoadProvider.get("custom-load-metric").asList();
                        Iterator it = list.iterator();
                        dynamicLoadProvider.get("custom-load-metric").set(newlist);
                        while (it.hasNext()) {
                            ModelNode node = (ModelNode)it.next();
                            if (node.get("class").asString().equals(classname)) continue;
                            dynamicLoadProvider.get("custom-load-metric").add(node);
                        }
                    } else {
                        dynamicLoadProvider.get("custom-load-metric").set(newlist);
                    }
                    dynamicLoadProvider.get("custom-load-metric").add(metric);
                }
            }, OperationContext.Stage.MODEL);
        }
        context.completeStep();
    }
}

