/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachable;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;

public final class ManifestClassPathProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Map<VirtualFile, AdditionalModuleSpecification> additionalModules;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getAttachment(Attachments.CLASS_PATH_ENTRIES) != null) {
            return;
        }
        List<ResourceRoot> resourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        DeploymentUnit parent = deploymentUnit.getParent();
        DeploymentUnit topLevelDeployment = parent == null ? deploymentUnit : parent;
        VirtualFile topLevelRoot = topLevelDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT).getRoot();
        ExternalModuleService externalModuleService = topLevelDeployment.getAttachment(Attachments.EXTERNAL_MODULE_SERVICE);
        List additionalModuleList = topLevelDeployment.getAttachment(Attachments.ADDITIONAL_MODULES);
        List topLevelResourceRoots = topLevelDeployment.getAttachment(Attachments.RESOURCE_ROOTS);
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        List<DeploymentUnit> subDeployments = deploymentUnit.getParent() == null ? deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS) : deploymentUnit.getParent().getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        HashMap<VirtualFile, ModuleIdentifier> subDeploymentModules = new HashMap<VirtualFile, ModuleIdentifier>();
        for (DeploymentUnit deployment : subDeployments) {
            ResourceRoot root = deployment.getAttachment(Attachments.DEPLOYMENT_ROOT);
            ModuleIdentifier identifier = deployment.getAttachment(Attachments.MODULE_IDENTIFIER);
            if (root == null || identifier == null) continue;
            subDeploymentModules.put(root.getRoot(), identifier);
        }
        if (additionalModuleList == null) {
            additionalModules = Collections.emptyMap();
        } else {
            additionalModules = new HashMap();
            for (AdditionalModuleSpecification module : additionalModuleList) {
                for (ResourceRoot additionalModuleResourceRoot : module.getResourceRoots()) {
                    additionalModules.put(additionalModuleResourceRoot.getRoot(), module);
                }
            }
        }
        HashSet<VirtualFile> earLibJars = new HashSet<VirtualFile>();
        if (deploymentUnit.getParent() != null && topLevelResourceRoots != null) {
            for (ResourceRoot resourceRoot : topLevelResourceRoots) {
                if (!ModuleRootMarker.isModuleRoot(resourceRoot) || SubDeploymentMarker.isSubDeployment(resourceRoot)) continue;
                earLibJars.add(resourceRoot.getRoot());
            }
        }
        for (ResourceRoot resourceRoot : resourceRoots) {
            String[] items;
            if (SubDeploymentMarker.isSubDeployment(resourceRoot) && resourceRoot != deploymentRoot) continue;
            Attachable target = additionalModules.containsKey(resourceRoot.getRoot()) ? (Attachable)additionalModules.get(resourceRoot.getRoot()) : deploymentUnit;
            for (String item : items = ManifestClassPathProcessor.getClassPathEntries(resourceRoot)) {
                boolean found = false;
                VirtualFile classPathFile = resourceRoot.getRoot().getParent().getChild(item);
                VirtualFile topLevelClassPathFile = deploymentRoot.getRoot().getParent().getChild(item);
                if (ManifestClassPathProcessor.isInside(classPathFile, topLevelRoot)) {
                    if (earLibJars.contains(classPathFile)) {
                        log.debugf("Class-Path entry %s in %s ignored, as target is in or referenced by /lib", (Object)classPathFile, (Object)resourceRoot.getRoot());
                        continue;
                    }
                    if (additionalModules.containsKey(classPathFile)) {
                        target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, ((AdditionalModuleSpecification)additionalModules.get(classPathFile)).getModuleIdentifier());
                        continue;
                    }
                    if (subDeploymentModules.containsKey(classPathFile)) {
                        target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, subDeploymentModules.get(classPathFile));
                        continue;
                    }
                    if (additionalModules.containsKey(topLevelClassPathFile)) {
                        target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, ((AdditionalModuleSpecification)additionalModules.get(topLevelClassPathFile)).getModuleIdentifier());
                        continue;
                    }
                    if (subDeploymentModules.containsKey(topLevelClassPathFile)) {
                        target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, subDeploymentModules.get(topLevelClassPathFile));
                        continue;
                    }
                    if (classPathFile.exists() && classPathFile.isDirectory() || topLevelClassPathFile.exists() && topLevelClassPathFile.isDirectory()) continue;
                    log.warn((Object)("Class Path entry " + item + " in " + resourceRoot.getRoot() + "  does not point to a valid jar for a Class-Path reference."));
                    continue;
                }
                if (item.startsWith("/")) {
                    ModuleIdentifier moduleIdentifier = externalModuleService.addExternalModule(item);
                    target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, moduleIdentifier);
                    log.debugf("Resource %s added as external jar %s", (Object)classPathFile, (Object)resourceRoot.getRoot());
                    continue;
                }
                log.debugf("Ignoring missing Class-Path entry %s", (Object)classPathFile);
            }
        }
    }

    private static boolean isInside(VirtualFile classPathFile, VirtualFile toplevelRoot) {
        VirtualFile[] parentPaths;
        for (VirtualFile path : parentPaths = classPathFile.getParentFiles()) {
            if (path != toplevelRoot) continue;
            return true;
        }
        return false;
    }

    private static String[] getClassPathEntries(ResourceRoot resourceRoot) {
        Manifest manifest = resourceRoot.getAttachment(Attachments.MANIFEST);
        if (manifest == null) {
            return EMPTY_STRING_ARRAY;
        }
        String classPathString = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPathString == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (classPathString.trim().isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        return classPathString.trim().split("\\s+");
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

