/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.pojo.descriptor.AbstractConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.Configurator;

public class LifecycleConfig
extends AbstractConfigVisitorNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String methodName;
    private ValueConfig[] parameters;
    private boolean ignored;

    @Override
    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
        if (this.parameters != null) {
            nodes.addAll(Arrays.asList(this.parameters));
        }
    }

    @Override
    public Class<?> getType(ConfigVisitor visitor, ConfigVisitorNode previous) {
        if (!(previous instanceof ValueConfig)) {
            throw new IllegalArgumentException("Previous node is not a value config!");
        }
        ValueConfig vc = (ValueConfig)previous;
        BeanInfo beanInfo = visitor.getBeanInfo();
        Method m = beanInfo.findMethod(this.methodName, Configurator.getTypes(this.parameters));
        return m.getParameterTypes()[vc.getIndex()];
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public ValueConfig[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ValueConfig[] parameters) {
        this.parameters = parameters;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }
}

