/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

final class InjectableMethod {
    private final Method method;
    private final List<Bean<?>> beans;
    private final List<InjectionPoint> injectionPoints;

    public InjectableMethod(final Method method, List<Bean<?>> beans, List<InjectionPoint> injectionPoints) {
        this.beans = beans;
        this.method = method;
        this.injectionPoints = injectionPoints;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
    }

    public void inject(Object instance, BeanManagerImpl beanManager, CreationalContext<?> ctx) {
        try {
            Object[] params = new Object[this.beans.size()];
            int i = 0;
            for (Bean<?> bean : this.beans) {
                Object value = beanManager.getReference(this.injectionPoints.get(i), bean, ctx);
                params[i++] = value;
            }
            this.method.invoke(instance, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to perform CDI injection of initializer method: " + this.method + " on " + instance.getClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to perform CDI injection of field: " + this.method + " on " + instance.getClass(), e);
        }
    }
}

