/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

public class InterceptorClassDeploymentDescriptorProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (metaData == null) {
            return;
        }
        if (metaData.getInterceptors() == null) {
            return;
        }
        for (InterceptorMetaData interceptor : metaData.getInterceptors()) {
            LifecycleCallbacksMetaData preDestroys;
            LifecycleCallbacksMetaData postConstructs;
            String interceptorClassName = interceptor.getInterceptorClass();
            AroundInvokesMetaData aroundInvokes = interceptor.getAroundInvokes();
            if (aroundInvokes != null) {
                for (AroundInvokeMetaData aroundInvoke : aroundInvokes) {
                    InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                    String methodName = aroundInvoke.getMethodName();
                    MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Object.class, (String)methodName, (Class[])new Class[]{InvocationContext.class});
                    builder.setAroundInvoke(methodIdentifier);
                    if (aroundInvoke.getClassName() == null || aroundInvoke.getClassName().isEmpty()) {
                        eeModuleDescription.addInterceptorMethodOverride(interceptorClassName, builder.build());
                        continue;
                    }
                    eeModuleDescription.addInterceptorMethodOverride(aroundInvoke.getClassName(), builder.build());
                }
            }
            if ((postConstructs = interceptor.getPostConstructs()) != null) {
                for (LifecycleCallbackMetaData postConstruct : postConstructs) {
                    InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                    String methodName = postConstruct.getMethodName();
                    MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{InvocationContext.class});
                    builder.setPostConstruct(methodIdentifier);
                    if (postConstruct.getClassName() == null || postConstruct.getClassName().isEmpty()) {
                        eeModuleDescription.addInterceptorMethodOverride(interceptorClassName, builder.build());
                        continue;
                    }
                    eeModuleDescription.addInterceptorMethodOverride(postConstruct.getClassName(), builder.build());
                }
            }
            if ((preDestroys = interceptor.getPreDestroys()) == null) continue;
            for (LifecycleCallbackMetaData preDestroy : preDestroys) {
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = preDestroy.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{InvocationContext.class});
                builder.setPreDestroy(methodIdentifier);
                if (preDestroy.getClassName() == null || preDestroy.getClassName().isEmpty()) {
                    eeModuleDescription.addInterceptorMethodOverride(interceptorClassName, builder.build());
                    continue;
                }
                eeModuleDescription.addInterceptorMethodOverride(preDestroy.getClassName(), builder.build());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

