/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop;

import java.lang.reflect.Proxy;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.iiop.EjbIIOPService;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;

public class ProxyTranslater {
    public static Object wrapPotentialProxy(DeploymentRepository deploymentRepository, Object retVal) {
        if (retVal instanceof Proxy) {
            EJBLocator locator;
            try {
                locator = EJBClient.getLocatorFor((Object)retVal);
            }
            catch (Exception e) {
                locator = null;
            }
            if (locator != null) {
                ModuleDeployment module = deploymentRepository.getModules().get(new DeploymentModuleIdentifier(locator.getAppName(), locator.getModuleName(), locator.getDistinctName()));
                if (module == null) {
                    throw new RuntimeException("Could not locate EJB for " + locator);
                }
                EjbDeploymentInformation ejb = module.getEjbs().get(locator.getBeanName());
                if (ejb == null) {
                    throw new RuntimeException("Could not locate EJB for " + locator);
                }
                EjbIIOPService factory = ejb.getIorFactory();
                if (factory == null) {
                    throw new RuntimeException("EJB " + locator + " is not exposed via IIOP");
                }
                retVal = factory.referenceForLocator((EJBLocator<? extends Object>)locator);
            }
        }
        return retVal;
    }
}

